(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    331354,       6944]
NotebookOptionsPosition[    304504,       6423]
NotebookOutlinePosition[    304900,       6439]
CellTagsIndexPosition[    304857,       6436]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equidiagonal-orthodiagonal  Trapezoid - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 3.9547567507460346`*^9}, {3.956299395625988*^9, 
  3.956299398221327*^9}, {3.9611288913702946`*^9, 
  3.9611289060726376`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about \
equidiagonal-orthodiagonal trapezoid in the paper \[OpenCurlyDoubleQuote]More \
Shapes of Central Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.954756791707377*^9}, {3.9611288076657352`*^9, 3.9611288216169415`*^9}, {
  3.961413121732936*^9, 
  3.961413133700441*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"9f6088f9-a2be-3140-964a-\
e41e398b8645"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", ">", "0"}], ",", 
      RowBox[{"b", ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}], ",", 
      RowBox[{"b", ">", "c"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "if", " ", "ABCD", " ", "is", " ", "a", " ", "equidiagonal", " ", 
    "orthodiagonal", " ", "trapezoid", " ", "then", " ", "ABCD", " ", "is", " ",
     "an", " ", "isosceles", " ", 
    RowBox[{"(", 
     RowBox[{"and", " ", "cyclic"}], ")"}], " ", "trapezoid"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"SimetriaAxial", "[", 
     RowBox[{"ptA", ",", 
      RowBox[{"Mediatriz", "[", 
       RowBox[{"ptB", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "condition", " ", "of", " ", "orthodiagonal", " ", "quadrilateral", " ", 
    "ABCD"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"SonPerpendiculares", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptB", ",", "ptD"}], "]"}], ",", "rtCA"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ortho", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], "\[Equal]", 
   "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.9547552492897663`*^9, 3.954755284434631*^9}, {
   3.956300926380308*^9, 3.956300984737869*^9}, {3.959907691606375*^9, 
   3.959907700916147*^9}, 3.959907744885479*^9, {3.9611426915172424`*^9, 
   3.9611427343742695`*^9}, {3.9611428966533737`*^9, 3.961142902887644*^9}, {
   3.9611429345195236`*^9, 3.9611429885680027`*^9}, {3.961143026514803*^9, 
   3.9611430305603848`*^9}, {3.9611436280742054`*^9, 3.9611436346172695`*^9}, 
   3.961144972195503*^9, {3.9611450050313015`*^9, 3.9611450215588017`*^9}},
 CellLabel->
  "In[362]:=",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{{3.96114302137998*^9, 3.961143032214039*^9}, {
   3.96114362942679*^9, 3.961143637753435*^9}, 3.961144973616646*^9, {
   3.961145007610615*^9, 3.9611450229010735`*^9}, 3.961413157782707*^9},
 CellLabel->
  "Out[365]=",ExpressionUUID->"5f6fa53c-439b-44f9-a380-21d5d5d422ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["a", "4"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], "2"]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.96114302137998*^9, 3.961143032214039*^9}, {
   3.96114362942679*^9, 3.961143637753435*^9}, 3.961144973616646*^9, {
   3.961145007610615*^9, 3.9611450229010735`*^9}, 3.961413157783296*^9},
 CellLabel->
  "Out[366]=",ExpressionUUID->"123aab62-bdab-4bdb-8a4b-18d9bc010755"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rhombusQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"And", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P", ",", "Q"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"Q", ",", "R"}], "]"}]}], "]"}], ",", "cond"}], "]"}], "===",
         "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"Q", ",", "R"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "cond"}], "]"}], "===",
         "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"R", ",", "S"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P", ",", "S"}], "]"}]}], "]"}], ",", "cond"}], "]"}], "===",
         "0"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"squareQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"And", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"perpendicularQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}], ",", "cond"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"rhombusQuadQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], ",", "cond"}], 
        "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.956299197234873*^9, 
   3.9562992014433975`*^9}, {3.956302404396764*^9, 3.956302474075535*^9}, {
   3.9563041601630363`*^9, 3.956304170018783*^9}, 3.956304207307005*^9, {
   3.9611431492374763`*^9, 3.9611431493887367`*^9}, {3.9611431994825153`*^9, 
   3.961143216587*^9}, {3.9611456751494904`*^9, 3.9611456854483986`*^9}, {
   3.9611457833552914`*^9, 3.9611457856161976`*^9}, 3.961413147109845*^9},
 CellLabel->
  "In[367]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 3.946441726397751*^9}, {3.956137230525439*^9, 
  3.956137236030091*^9}, {3.956137322420559*^9, 3.956137323751978*^9}, {
  3.9561374910757213`*^9, 
  3.956137494516241*^9}},ExpressionUUID->"3cbb4941-f491-e944-a1fa-\
7bd4c19f5af3"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQtcTdkb9/fpZdRnDt7My1/zj6J/pMmg3HIZhXIbcgtD7o1LiHKLQYxL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    "], {{0, 135.16981132075472`}, {563.0943396226414, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{563.0943396226414, 135.16981132075472`},
  PlotRange->{{0, 563.0943396226414}, {0, 135.16981132075472`}}]], "Text",
 CellChangeTimes->{
  3.956137328142054*^9, 3.956137472932368*^9, 3.9562965472861385`*^9, 
   3.9599102952434273`*^9, {3.961142813928625*^9, 
   3.9611428266679287`*^9}},ExpressionUUID->"a44dd8ce-716c-ff47-b686-\
3d356d61de25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", "ptO", 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "Steiner", " ", "point", " ", "of", " ", "a", " ", "cyclic", " ",
     "quadrilateral", " ", "ABCD", " ", "coincides", " ", "with", " ", "its", 
    " ", "circumcenter"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
   3.954745534742643*^9, 3.954745542313005*^9}, {3.954756841827467*^9, 
   3.954756852715332*^9}, {3.955504132039633*^9, 3.955504186320764*^9}, {
   3.955504219539226*^9, 3.955504248205105*^9}, {3.956301695357956*^9, 
   3.9563017003307*^9}, {3.956301764956686*^9, 3.956301815498993*^9}, 
   3.956304835816866*^9, {3.961143057310259*^9, 3.9611430585180855`*^9}},
 CellLabel->
  "In[377]:=",ExpressionUUID->"24c0694c-7ce6-5a4a-a7ef-49ffd3a8021d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.961143288782799*^9, 3.961413157844097*^9},
 CellLabel->
  "Out[377]=",ExpressionUUID->"7281f5e7-eaf0-4268-b269-c1e7dfdf698c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI  square ", "Section",
 CellChangeTimes->{{3.959043975817276*^9, 
  3.95904398797558*^9}},ExpressionUUID->"533a37db-4bf4-c049-b2cf-\
748105802c1b"],

Cell[CellGroupData[{

Cell["X \[Element] \[DoubleStruckCapitalM] ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, 3.9611431289854927`*^9, {3.9611462947528324`*^9, 
   3.9611462958247128`*^9}},ExpressionUUID->"1254f18b-db3a-2d45-9037-\
02c91cd4cbbc"],

Cell["\<\
If  n\[Element]\[DoubleStruckCapitalM] then, by lemma 7.4,  F,G,H,I are the \
midpoints of AB, BC, CD, DA respectively. Therefore FG || AC, FG=AC/2, GH || \
BD, GH=BD/2, HI || CA, HI=CA/2, IF || BD, IF=BD/2. Hence FGHI is a square.\
\>", "Text",
 CellChangeTimes->{{3.9590439954835443`*^9, 3.959044041168476*^9}, {
  3.959044151810156*^9, 3.9590444167704334`*^9}, {3.95904446076993*^9, 
  3.9590444797297*^9}},ExpressionUUID->"e4f23084-35ad-8447-a2e8-950e78b432d0"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (2)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}},ExpressionUUID->"f450e165-3fe4-bb4e-a74a-\
07f6cc214c8b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"2", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
   3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
   3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
   3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
   3.956301837011614*^9}, 3.9611432605779324`*^9, {3.961143334593649*^9, 
   3.961143336711836*^9}, 3.961143569298128*^9},
 CellLabel->
  "In[378]:=",ExpressionUUID->"a8d42ec2-059d-c243-b392-16ec74ba5058"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296864578279*^9}, 3.956297953537765*^9, {3.956298359359873*^9, 
   3.956298365910711*^9}, 3.95630183850609*^9, 3.956302078918686*^9, 
   3.9563024094841175`*^9, 3.956302478920173*^9, 3.9563039459276447`*^9, {
   3.956304186818254*^9, 3.956304241471213*^9}, 3.959044571757355*^9, 
   3.9599049265585175`*^9, 3.959908076108726*^9, {3.9611432373875275`*^9, 
   3.961143261545904*^9}, 3.9611433378419895`*^9, 3.9611435708242626`*^9, 
   3.9614131580455847`*^9},
 CellLabel->
  "Out[379]=",ExpressionUUID->"65be21cc-17bd-4acd-bf34-71c132d19b5f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (148)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 
   3.956296860709921*^9}},ExpressionUUID->"bea0bf56-1c20-f04b-8dac-\
70e8e7d696e3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"148", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296873247749*^9}, {
  3.956304244701731*^9, 3.956304251156979*^9}, {3.9611433470678387`*^9, 
  3.961143348664547*^9}},
 CellLabel->
  "In[380]:=",ExpressionUUID->"c646ccab-f488-1649-bcfb-b88a2ce46760"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296873939614*^9}, {3.956304225047653*^9, 3.956304252192379*^9}, 
   3.9590445786599865`*^9, 3.959908083683428*^9, 3.961143349958372*^9, 
   3.96141315825506*^9},
 CellLabel->
  "Out[381]=",ExpressionUUID->"6537f68b-a366-4cb3-8b66-ffb0a22a37dc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (149)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296885822828*^9}, 
   3.9563043855618668`*^9, {3.95630474590437*^9, 3.956304748472822*^9}, {
   3.95990821093676*^9, 
   3.959908213248028*^9}},ExpressionUUID->"c1e1f6cc-d884-644d-94a7-\
d95785ef3f56"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"149", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.961143373824066*^9, 3.9611433738953285`*^9}},
 CellLabel->
  "In[382]:=",ExpressionUUID->"cba32ffa-8174-7249-83a3-614233702119"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.96114337815794*^9, 3.961413164407563*^9},
 CellLabel->
  "Out[383]=",ExpressionUUID->"e85e9d4f-e255-4456-943e-b07a29869bbe"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (150)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.956296900662128*^9, 3.9562969011925735`*^9}, 3.9563044584345417`*^9, {
   3.95630475525532*^9, 3.956304755688368*^9}, 
   3.959908434080536*^9},ExpressionUUID->"e584b43c-491d-ce46-b522-\
e13074723ba3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"150", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.961143399380863*^9, 3.961143400080473*^9}},
 CellLabel->
  "In[384]:=",ExpressionUUID->"a8af9933-d29a-aa4c-9ce2-05e684bcb4de"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611434034498672`*^9, 3.961413169648356*^9},
 CellLabel->
  "Out[385]=",ExpressionUUID->"8d201a75-45b2-48ff-a5a0-4b2a65271d3d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (290)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.95629691927927*^9, 
   3.956296920078129*^9}},ExpressionUUID->"16a51a0e-fbcc-b94b-9131-\
8ce8b8b4b133"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"290", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296873247749*^9}, {
  3.956296924824644*^9, 3.956296925527523*^9}, {3.956304466708608*^9, 
  3.956304488262118*^9}, {3.961143422924303*^9, 3.9611434240312786`*^9}},
 CellLabel->
  "In[386]:=",ExpressionUUID->"7a1a86b9-f66e-424f-ab17-68735df15c97"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296873939614*^9}, 3.956296926579653*^9, {3.956304470704731*^9, 
   3.9563045000273056`*^9}, 3.959908478990541*^9, 3.9611434248248005`*^9, 
   3.961413169947291*^9},
 CellLabel->
  "Out[387]=",ExpressionUUID->"26686a44-be8d-4929-97be-7cd25a3b4b0a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (402)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.956296937014276*^9, 3.956296938023544*^9}, {3.956297296993181*^9, 
   3.956297301278621*^9}, {3.956297480374555*^9, 3.956297514283746*^9}, 
   3.956304589162388*^9, {3.956304763008365*^9, 3.956304784520269*^9}, 
   3.959908692000595*^9},ExpressionUUID->"583236b4-0e1c-d248-84b6-\
1eb97e5315c6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X402", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"402", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X402", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
   3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
   3.956138726774135*^9}, {3.956296781016487*^9, 3.956296873247749*^9}, {
   3.956296943408443*^9, 3.956296959107483*^9}, {3.9562969914326077`*^9, 
   3.956296998183939*^9}, {3.9563045090767994`*^9, 3.956304516007576*^9}, {
   3.959908567943136*^9, 3.959908572844513*^9}, {3.9599086310604343`*^9, 
   3.959908641498169*^9}, 3.959908676955616*^9, {3.961143441707796*^9, 
   3.961143466121397*^9}},
 CellLabel->
  "In[388]:=",ExpressionUUID->"03fde7ca-7e12-404f-a91f-ed5b80ae69b3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296873939614*^9}, 3.9562969502425747`*^9, {3.956296984050484*^9, 
   3.956297001587483*^9}, 3.9563045451582966`*^9, 3.9590467890528927`*^9, {
   3.959908555123665*^9, 3.959908574940489*^9}, {3.959908658052084*^9, 
   3.959908685668621*^9}, {3.961143450647211*^9, 3.9611434671143627`*^9}, 
   3.961413170611902*^9},
 CellLabel->
  "Out[390]=",ExpressionUUID->"03920aa8-8cfb-4c45-ba1e-5056d737bf93"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (620) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.9562973148624516`*^9, 3.956297315686695*^9}, 3.956297407079548*^9, {
   3.956297521078947*^9, 3.9562975244304104`*^9}, 3.956304623210659*^9, {
   3.956304779120268*^9, 3.956304780896269*^9}, 
   3.959908733957214*^9},ExpressionUUID->"dd86b5f2-8cad-f440-8230-\
698e7bd59518"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X620", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"620", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X620", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
   3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
   3.956138726774135*^9}, {3.956296781016487*^9, 3.956296873247749*^9}, {
   3.956297322793178*^9, 3.956297345907563*^9}, {3.9563046011167736`*^9, 
   3.9563046022756844`*^9}, 3.9599087274343624`*^9, 3.959908814966316*^9, {
   3.961143478423929*^9, 3.961143504775812*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"c3629827-eae7-294d-b29c-1d848a2d2079"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296873939614*^9}, {3.95629732713081*^9, 3.9562973504534187`*^9}, 
   3.956304609145204*^9, 3.9599087355856037`*^9, 3.959908817887337*^9, 
   3.961143505650543*^9, 3.9614131707788143`*^9},
 CellLabel->
  "Out[393]=",ExpressionUUID->"0df3e899-1026-412c-bc3c-765c2635564d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (671)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.95629691927927*^9, 3.956296920078129*^9}, {3.956297436198641*^9, 
   3.956297436759676*^9}},ExpressionUUID->"0324d82f-1439-9c4d-b70f-\
a91e07cd4dc6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"671", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
   3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
   3.956138726774135*^9}, {3.956296781016487*^9, 3.956296873247749*^9}, {
   3.956296924824644*^9, 3.956296925527523*^9}, {3.9562974424478664`*^9, 
   3.9562974443915424`*^9}, {3.956304631589155*^9, 3.956304634956045*^9}, 
   3.959908830130865*^9, {3.961143516957266*^9, 3.961143518318243*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"a1466a81-6ddb-a443-aa00-826f51c37fd0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.956296806640774*^9, {3.956296838632728*^9, 
   3.956296873939614*^9}, 3.956296926579653*^9, 3.95629744544767*^9, 
   3.956304636367084*^9, 3.9599088327208605`*^9, 3.9611435193294945`*^9, 
   3.9614131710097923`*^9},
 CellLabel->
  "Out[395]=",ExpressionUUID->"e6b011e4-d025-4aec-a84f-2ed23fa1ba5b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (903)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.956296859910677*^9, 3.956296860709921*^9}, {
   3.95629691927927*^9, 3.956296920078129*^9}, {3.956297458534693*^9, 
   3.956297459502645*^9}, 3.956304814839737*^9, 
   3.9599092046410217`*^9},ExpressionUUID->"9e26f302-098c-b74d-b3cb-\
e544cbe68b2a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X903", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"903", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X903", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.961143534536215*^9, 3.9611435479284286`*^9}},
 CellLabel->
  "In[396]:=",ExpressionUUID->"bdf02d03-b236-7344-b34a-0f328e737114"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961143549308281*^9, 3.961413171224453*^9},
 CellLabel->
  "Out[398]=",ExpressionUUID->"43fe9452-aa97-41ab-bcb1-0bcb97f45f1f"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  equidiagonal kite", "Section",
 CellChangeTimes->{{3.959043975817276*^9, 3.95904398797558*^9}, {
  3.959044494170885*^9, 3.959044501522095*^9}, {3.961143667206951*^9, 
  3.9611436705199184`*^9}},ExpressionUUID->"38350a6d-5fe1-314f-b6b7-\
2ebc74453d7a"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQlcVde1/9PMJk3bvA626fiapMm/zXt5SV+a9uW91zRJX9K0YZ5nRAaR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    "], {{0, 257.4339622641509}, {257.4339622641509, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{257.4339622641509, 257.4339622641509},
  PlotRange->{{0, 257.4339622641509}, {0, 257.4339622641509}}]], "Text",
 CellChangeTimes->{
  3.96114480334754*^9},ExpressionUUID->"7e42d067-23c5-fd44-b1b1-ad22f03b076f"],

Cell[CellGroupData[{

Cell["X (13)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, 
   3.959048035949947*^9, 3.959909800914057*^9, {3.959910573978491*^9, 
   3.9599105740108624`*^9}},ExpressionUUID->"cc794e42-092d-0e46-9a3a-\
f415d61346d6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X13", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"13", ",", "2"}], "]"}], "]"}], "]"}], "/.", "sustS"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X13", ",", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X13", ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X13", ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptI", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{"X13", ",", 
        RowBox[{"{", 
         RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"Numerator", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "/.", "sustS"}], "]"}], 
    "]"}], ",", "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9599092522899876`*^9, 3.959909369611046*^9}, {
  3.959910578853131*^9, 3.959910578880059*^9}, {3.96114368153689*^9, 
  3.961143754793482*^9}, {3.9611441603795013`*^9, 3.9611441637539062`*^9}, {
  3.961144563387705*^9, 3.961144567890564*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"f8da1f3c-f77c-c94e-ad6c-9bc93b46609c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.959909253792959*^9, 3.9599093703124866`*^9}, 
   3.959910579626829*^9, 3.9611437699371758`*^9, 3.9611441768123493`*^9, 
   3.961144582718338*^9, 3.9611457490614376`*^9, 3.961413192456452*^9},
 CellLabel->
  "Out[404]=",ExpressionUUID->"e4fbd796-7ffe-4938-a81a-c783ade76de9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, 
   3.959048035949947*^9, 
   3.959909800914057*^9},ExpressionUUID->"968e4dfa-298c-0548-91fc-\
0a1085d64484"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X14", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"14", ",", "2"}], "]"}], "]"}], "]"}], "/.", "sustS"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X14", ",", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X14", ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X14", ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptI", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{"X14", ",", 
        RowBox[{"{", 
         RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"Numerator", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "/.", "sustS"}], "]"}], 
    "]"}], ",", "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9599092522899876`*^9, 3.959909369611046*^9}, {
  3.959910578853131*^9, 3.959910578880059*^9}, {3.96114368153689*^9, 
  3.961143754793482*^9}, {3.9611437859063625`*^9, 3.9611437960242157`*^9}},
 CellLabel->
  "In[405]:=",ExpressionUUID->"63abb9a1-e6a4-a548-a3bb-13b02bc5d9e1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.959909253792959*^9, 3.9599093703124866`*^9}, 
   3.959910579626829*^9, 3.9611437699371758`*^9, 3.9611438128498173`*^9, 
   3.961413213695342*^9},
 CellLabel->
  "Out[410]=",ExpressionUUID->"10cc25b7-813a-4584-8bf0-fbc2677f09e8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (616)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, {
   3.959048035949947*^9, 3.959048053284618*^9}, {3.959048125341612*^9, 
   3.959048126837402*^9}, {3.9599100358419666`*^9, 
   3.9599100359938717`*^9}},ExpressionUUID->"5e344956-7723-fb49-b657-\
3d66bf0356a0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X616", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"616", ",", "2"}], "]"}], "]"}], "]"}], "/.", "sustS"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X616", ",", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X616", ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X616", ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptI", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{"X616", ",", 
        RowBox[{"{", 
         RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"Numerator", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "/.", "sustS"}], "]"}], 
    "]"}], ",", "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9599092522899876`*^9, 3.959909369611046*^9}, {
  3.959910578853131*^9, 3.959910578880059*^9}, {3.96114368153689*^9, 
  3.961143754793482*^9}, {3.9611438359536057`*^9, 3.961143853000431*^9}},
 CellLabel->
  "In[411]:=",ExpressionUUID->"49ee31df-9955-a649-8536-3ca507ad9f86"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.959909253792959*^9, 3.9599093703124866`*^9}, 
   3.959910579626829*^9, 3.9611437699371758`*^9, 3.9611438701016216`*^9, 
   3.9614132372876062`*^9},
 CellLabel->
  "Out[416]=",ExpressionUUID->"eb885fed-0024-4be8-bab6-2c6d26b5b2ae"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (617)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, {
   3.959048035949947*^9, 3.959048053284618*^9}, {3.959048125341612*^9, 
   3.959048126837402*^9}, {3.9599100358419666`*^9, 
   3.9599100537804775`*^9}},ExpressionUUID->"9ff4b1d7-e1c5-7546-ac5a-\
7f2d3f7bcea4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X617", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"617", ",", "2"}], "]"}], "]"}], "]"}], "/.", "sustS"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X617", ",", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X617", ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X617", ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptI", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{"X617", ",", 
        RowBox[{"{", 
         RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"Numerator", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "/.", "sustS"}], "]"}], 
    "]"}], ",", "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9611438950499344`*^9, 3.9611439034525433`*^9}},
 CellLabel->
  "In[417]:=",ExpressionUUID->"ee79f7a1-38e5-874a-8058-5e2c86d96d6e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.961143919943428*^9, 3.961413261173394*^9},
 CellLabel->
  "Out[422]=",ExpressionUUID->"f620facc-6922-49b9-9143-cdfbeb75c514"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (618)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, {
   3.959048035949947*^9, 3.959048053284618*^9}, {3.959048125341612*^9, 
   3.959048126837402*^9}, {3.9599100358419666`*^9, 3.9599100537804775`*^9}, {
   3.9599101250661106`*^9, 
   3.959910125162325*^9}},ExpressionUUID->"53bceed0-9e99-0342-b145-\
1959731f4015"],

Cell[TextData[{
 "Since  X(618) contains Conway symbols we must use the substitution sustC. \n\
",
 StyleBox["Remind that centroETCTriangulo[ptX,trT] does not work if the \
coordinates of ptX contain a Conway symbol !",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{{3.95613881758579*^9, 3.956139005893421*^9}, {
  3.956139037861418*^9, 
  3.95613903833988*^9}},ExpressionUUID->"7ed96f33-7dbc-754d-a859-\
1575b76fb14c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X618", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"ETC", "[", 
        RowBox[{"[", 
         RowBox[{"618", ",", "2"}], "]"}], "]"}], "]"}], "/.", "sustS"}], "/.",
      "sustC"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X618", ",", 
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X618", ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{"X618", ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptI", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{"X618", ",", 
        RowBox[{"{", 
         RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"Numerator", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "/.", "sustS"}], "]"}], 
    "]"}], ",", "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9611439487448826`*^9, 3.9611439583744774`*^9}, {
  3.9611448346845684`*^9, 3.9611448509874897`*^9}},
 CellLabel->
  "In[423]:=",ExpressionUUID->"a0a81fd9-0ff2-6a41-994b-6071d4308ae8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9611441505092525`*^9, 3.9611448123921337`*^9, 
  3.9611448777825584`*^9, 3.961413284486485*^9},
 CellLabel->
  "Out[428]=",ExpressionUUID->"402aebac-590f-47c0-92ca-7d517cd6b34e"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  right kite", "Section",
 CellChangeTimes->{{3.959043975817276*^9, 3.95904398797558*^9}, {
  3.959044494170885*^9, 3.9590445015220947`*^9}, {3.959048728285372*^9, 
  3.9590487295022507`*^9}},ExpressionUUID->"ac27efec-3713-4e45-aca2-\
9089e1a79c3f"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQdcVVe2/zPpJpk3mXmZSTL5p8xkMsm8Ke+9vJmXycu8N2kzk8xEeu9I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    "], {{0, 285.9622641509434}, {263.5471698113207, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{263.5471698113207, 285.9622641509434},
  PlotRange->{{0, 263.5471698113207}, {0, 285.9622641509434}}]], "Text",
 CellChangeTimes->{
  3.9611454845803375`*^9},ExpressionUUID->"efb7d5a2-9d81-4c4e-9ced-\
822dcb5e3185"],

Cell["\<\
An  Equidiagonal  Orthodiagonal  Trapezoid  is  an  isosceles trapezoid  and  \
is  cyclic . 
As  an  isosceles  trapezoid, the  central  quadrilateral  is always  a  kite \
. 
Hence we must only prove that IF is perpendicular to FG.\
\>", "Text",
 CellChangeTimes->{{3.961145943509117*^9, 3.961145959072996*^9}, {
  3.9611460805122414`*^9, 3.9611460817363834`*^9}, {3.9611463547932663`*^9, 
  3.9611463665768414`*^9}, {3.9611463983768654`*^9, 
  3.9611464229913273`*^9}},ExpressionUUID->"802b14b4-b634-0949-9b05-\
85ca74b37d8b"],

Cell[CellGroupData[{

Cell["X (3)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 
   3.959910694900997*^9}},ExpressionUUID->"cbecca4b-1afc-0941-9b3a-\
241a5a1f2ec9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"3", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.9611462652404404`*^9, 3.961146266075468*^9}},
 CellLabel->
  "In[429]:=",ExpressionUUID->"ad88972e-1c9b-6944-9aa3-9d5d2f872d16"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611462675697536`*^9, 3.961413284745153*^9},
 CellLabel->
  "Out[430]=",ExpressionUUID->"48b97a94-cb35-41aa-97c3-0f1fccfa2d16"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (399)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 
   3.9599107917149734`*^9}},ExpressionUUID->"34f4d9b9-45b2-1c4f-bf42-\
dfd3ce95a916"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X399", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"399", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "/.", 
    "sustS"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959910846941826*^9, 3.959910864781103*^9}, {
  3.9611455616623497`*^9, 3.9611455638807697`*^9}},
 CellLabel->
  "In[431]:=",ExpressionUUID->"dd28dea8-4c4a-5749-935a-21b580c8fa35"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9599108486323767`*^9, 3.959910865585932*^9}, 
   3.961145566804041*^9, 3.961413284806952*^9},
 CellLabel->
  "Out[431]=",ExpressionUUID->"4ccbf67e-b860-4a9e-b054-577135411de0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X399", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.961145570866127*^9, 3.961145580217081*^9}},
 CellLabel->
  "In[432]:=",ExpressionUUID->"a7828c3c-f3b5-f94a-9149-60c06a329207"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.961145582979599*^9, 
  3.961413285312101*^9},
 CellLabel->
  "Out[433]=",ExpressionUUID->"3f47dd00-6784-4011-a417-419aeb293366"]
}, Open  ]],

Cell[TextData[{
 "T=74, 98, 102-106, 111, 477, 675, 697, 699, 701, 703, 705, 707, 709, 711, \
713, 715, 717, 719, 721, 723, 725, 727,",
 StyleBox[" ",
  FontColor->RGBColor[1, 0, 0]],
 "729, 731, 733, 735, 737, 739, 741, 743, 745, 747, 753,",
 StyleBox[" ",
  FontColor->RGBColor[1, 0, 0]],
 "755, 759, 761, 767, 840, 841, 842, 843, 915, 917, 953, 972"
}], "Text",
 CellChangeTimes->{{3.9599118083792953`*^9, 3.9599118586528816`*^9}, {
  3.959917152234793*^9, 3.959917225468037*^9}, {3.96114806342671*^9, 
  3.961148070130165*^9}, {3.9611482282193737`*^9, 3.961148248714863*^9}, {
  3.961148520634453*^9, 3.9611485844192142`*^9}, {3.9611486679470215`*^9, 
  3.9611486778854313`*^9}, {3.961148814483362*^9, 3.9611488654342136`*^9}, {
  3.9611489754235687`*^9, 3.961148990871668*^9}, {3.96114929313262*^9, 
  3.961149324085085*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"f4a8ad7b-da6e-604a-bc93-45b9301a659c"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (74)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}},ExpressionUUID->"076fc163-5c9c-e44f-a8ef-\
ecc9b7615e78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"74", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.959912215807907*^9, 3.959912216279196*^9}, {
  3.961146443794998*^9, 3.9611464457232323`*^9}},
 CellLabel->
  "In[434]:=",ExpressionUUID->"1b0dcbf0-60a1-ac47-82a4-9a7a8b08775a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912218181772*^9, 3.9611464480922604`*^9, 3.961413285449596*^9},
 CellLabel->
  "Out[435]=",ExpressionUUID->"dedd1013-d52a-4110-a811-d61ad4fc3a40"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (98)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 
   3.959912081276663*^9}},ExpressionUUID->"864c518f-92bf-0041-b77b-\
ffc37f71a77f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"98", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.959912196368419*^9, 3.959912196550756*^9}, {
  3.961146458459593*^9, 3.961146460474251*^9}},
 CellLabel->
  "In[436]:=",ExpressionUUID->"5d797067-6414-8945-9820-353c14e015bb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.9599121990681047`*^9, 3.9611464614653606`*^9, 
  3.961413285586215*^9},
 CellLabel->
  "Out[437]=",ExpressionUUID->"54311648-da73-4a26-9379-df100805dd59"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (102)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, 
   3.961146479424515*^9},ExpressionUUID->"5a50ba19-57c9-3449-b4f7-\
3eccc51ee319"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"102", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.961146471043535*^9, 3.9611464726669407`*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"c530beb9-e8cd-244a-bf85-4afef3ee0d43"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.96114647404797*^9, 3.961413286266062*^9},
 CellLabel->
  "Out[439]=",ExpressionUUID->"e022a84f-fc7f-454a-82b9-f783c065c6a3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (103)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912310681988*^9}, 
   3.9611464861679688`*^9},ExpressionUUID->"1fc764e1-24b4-a544-ae1d-\
aaaae38970fe"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"103", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.95991231684342*^9}, {3.9611464900752106`*^9, 
  3.9611464919384365`*^9}},
 CellLabel->
  "In[440]:=",ExpressionUUID->"136ba42a-33f9-c54f-b64d-7fef60d92444"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.9599123404527683`*^9, 3.961146493400093*^9, 3.961413286901278*^9},
 CellLabel->
  "Out[441]=",ExpressionUUID->"12c7d0aa-50ee-476b-b4f7-789eecc5f62d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (104)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, 
   3.9611465094485474`*^9},ExpressionUUID->"4d9164ba-bcf1-7d46-9bc4-\
c52e02336e07"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"104", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.959912332537845*^9}, {3.9611465022662582`*^9, 
  3.961146503834486*^9}},
 CellLabel->
  "In[442]:=",ExpressionUUID->"cc569792-626a-7b42-80e4-8be5b917d63c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.9599123674391785`*^9, 3.9611465066901226`*^9, 3.961413290363871*^9},
 CellLabel->
  "Out[443]=",ExpressionUUID->"b17fe268-6809-4355-ba8a-71038c80f0a9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (105)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.959912358714287*^9}, 
   3.9611465250003624`*^9},ExpressionUUID->"43b94a0f-516c-2646-bdf8-\
cdc2e16c7a4d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"105", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.959912332537845*^9}, {3.959912362890285*^9, 
  3.95991236297829*^9}, {3.961146516643585*^9, 3.961146518139015*^9}},
 CellLabel->
  "In[444]:=",ExpressionUUID->"aa964a52-06cb-0d42-98c6-447af230825a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.959912394578584*^9, 3.9611465209109783`*^9, 3.9614132917921*^9},
 CellLabel->
  "Out[445]=",ExpressionUUID->"1f66cf37-a771-4ac5-a78a-a995675a5637"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (106)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, 
   3.9611465506086407`*^9},ExpressionUUID->"9b9f6a84-59e6-f442-afcf-\
0d7cd4a5132a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"106", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.959912332537845*^9}, {3.959912362890285*^9, 
  3.959912382402951*^9}, {3.961146532602316*^9, 3.9611465349225864`*^9}},
 CellLabel->
  "In[446]:=",ExpressionUUID->"344b3244-7e02-c942-b143-bdbbd2467004"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.959912428269337*^9, 3.9611465450574036`*^9, 3.961413292035651*^9},
 CellLabel->
  "Out[447]=",ExpressionUUID->"21016768-8dbe-49b0-8f82-74c24a92723d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (111)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124509901257`*^9, 
   3.9599124627809315`*^9}},ExpressionUUID->"b2765b9d-6311-794d-bb81-\
f6b4bffb23e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"111", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.959912332537845*^9}, {3.959912362890285*^9, 
  3.959912382402951*^9}, {3.95991245525543*^9, 3.959912455886591*^9}, {
  3.9611465583641567`*^9, 3.9611465599464436`*^9}},
 CellLabel->
  "In[448]:=",ExpressionUUID->"d602a654-0d9d-5244-8b0c-d095d16e9061"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959910899400053*^9, 3.9599119766112957`*^9, 
  3.959912077358137*^9, 3.959912182266248*^9, 3.959912264554037*^9, 
  3.959912428269337*^9, 3.959912458318222*^9, 3.9611465608936653`*^9, 
  3.9614132921652937`*^9},
 CellLabel->
  "Out[449]=",ExpressionUUID->"15d8c6a3-e569-4319-9d3a-8bf5ad1ebaa9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (477)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, 
   3.9599126677012196`*^9},ExpressionUUID->"766dcc29-4b9f-5545-be17-\
9b2b3453ff31"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X477", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"477", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X477", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959910701685911*^9, 3.9599107175334644`*^9}, {
  3.959910796589205*^9, 3.959910797731924*^9}, {3.9599108722449474`*^9, 
  3.959910896525724*^9}, {3.9599122252487383`*^9, 3.959912225958799*^9}, {
  3.9599123168003044`*^9, 3.959912332537845*^9}, {3.959912362890285*^9, 
  3.959912382402951*^9}, {3.959912496072033*^9, 3.9599124968237677`*^9}, {
  3.9599126432171535`*^9, 3.959912644062763*^9}, {3.961146576041353*^9, 
  3.9611466020123024`*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"0bc6a4ad-bfdb-6348-88ff-6edd22355ca0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.959910899400053*^9, 3.9599119766112957`*^9, 3.959912077358137*^9, 
   3.959912182266248*^9, 3.959912264554037*^9, 3.959912428269337*^9, 
   3.9599125116467724`*^9, 3.9599125901898203`*^9, {3.9599126550094185`*^9, 
   3.959912663738119*^9}, {3.961146592541731*^9, 3.9611466031866913`*^9}, 
   3.961413292979151*^9},
 CellLabel->
  "Out[452]=",ExpressionUUID->"a39cac49-c626-4f3e-8e89-51491bdda363"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (675)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, 3.9599127148106823`*^9, 
   3.961146644312628*^9},ExpressionUUID->"e656cafe-5be8-b84c-a27c-\
e1e2cbef63c8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"675", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611481221800137`*^9, 3.9611481227234745`*^9}},
 CellLabel->
  "In[453]:=",ExpressionUUID->"904deae3-1b5a-5446-ada0-7c7fde91af5d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611481263549614`*^9, 3.9614132963526917`*^9},
 CellLabel->
  "Out[454]=",ExpressionUUID->"e7e34ff3-d304-491b-85ce-4bee27daa6c7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (697)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, 3.9599127148106823`*^9, 3.961146644312628*^9, {
   3.961148169899788*^9, 
   3.9611481701470737`*^9}},ExpressionUUID->"fb522d8b-c811-4d46-9f4c-\
ac47ce2e6912"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"697", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611481221800137`*^9, 3.9611481227234745`*^9}, {
  3.9611481750832233`*^9, 3.96114817536438*^9}},
 CellLabel->
  "In[455]:=",ExpressionUUID->"e5d79516-197c-c944-8278-e24ef3ad13de"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611481263549614`*^9, 3.9611481766106777`*^9, 
  3.961413296646577*^9},
 CellLabel->
  "Out[456]=",ExpressionUUID->"66a84472-ac45-4ad5-9fc0-c6b28c302d03"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (699)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, 
   3.9611466873848457`*^9},ExpressionUUID->"7dab8625-c598-0540-b5cc-\
924e18ad05ee"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"699", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148195259819*^9, 3.9611481952898083`*^9}},
 CellLabel->
  "In[457]:=",ExpressionUUID->"54d83243-3ffa-b047-a851-b94930168d3a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148196277321*^9, 3.9614132968218107`*^9},
 CellLabel->
  "Out[458]=",ExpressionUUID->"def4b540-e932-4827-aec1-dc9bb2217b98"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (701)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.9599128277470703`*^9}, 
   3.961146719536356*^9},ExpressionUUID->"c0028e2e-feea-9242-8065-\
7114dbbcb1e2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"701", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148214099991*^9, 3.9611482149231796`*^9}},
 CellLabel->
  "In[459]:=",ExpressionUUID->"e4dfc51d-d737-5b47-9bae-b18b5227115c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611482160721607`*^9, 3.961413297198732*^9},
 CellLabel->
  "Out[460]=",ExpressionUUID->"a722850e-091a-43af-bcf1-74188c89ad25"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (702)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.9599126130529404`*^9}, {3.9599127148106823`*^9, 
   3.9599127424235973`*^9}, {3.9599127959496765`*^9, 3.9599128512270584`*^9}, 
   3.959912890482128*^9},ExpressionUUID->"3a8e5026-d3dc-0e4b-a6eb-\
1930e7aa1872"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X702", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"702", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X702", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961146738410759*^9, 3.9611467433619213`*^9}},
 CellLabel->
  "In[461]:=",ExpressionUUID->"a91ff866-f35c-f446-8f9c-483e7302aa33"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611467444978523`*^9, 3.96141329737252*^9},
 CellLabel->
  "Out[463]=",ExpressionUUID->"1b92ac39-280d-498b-ba66-b0b8c2dcffc0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (703)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912953189546*^9}},ExpressionUUID->"cc3e069e-3500-ea45-8ef9-\
c59abc9645b6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X703", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"703", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X703", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611467586265984`*^9, 3.9611467633901196`*^9}},
 CellLabel->
  "In[464]:=",ExpressionUUID->"c7b9e63d-2f61-5745-9c04-4b506520c63d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961146764556734*^9, 3.961413297620728*^9},
 CellLabel->
  "Out[466]=",ExpressionUUID->"4aea6cb0-a107-49b5-ab3e-fa4acc9b81b4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (705)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912963991358*^9}, 3.9599130546026993`*^9, 
   3.9611467890335674`*^9},ExpressionUUID->"2f3c6052-f475-2d4a-a767-\
d0dc2a814ca1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"705", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611482728918743`*^9, 3.961148273827593*^9}},
 CellLabel->
  "In[467]:=",ExpressionUUID->"4a2447fc-3823-a34b-a1a6-c0f0f462a004"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148275728388*^9, 3.961413298326744*^9},
 CellLabel->
  "Out[468]=",ExpressionUUID->"6c450976-bc29-4c45-a018-a828915b039f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (707)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, 3.959913079347145*^9, 
   3.9611468107131996`*^9},ExpressionUUID->"1ffd9eb7-af51-264b-a1e1-\
ccf5a026b6dc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"707", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611482899159393`*^9, 3.9611482907797985`*^9}},
 CellLabel->
  "In[469]:=",ExpressionUUID->"daa197fc-2626-3846-a086-731ab76fd6d6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148291784916*^9, 3.961413298612897*^9},
 CellLabel->
  "Out[470]=",ExpressionUUID->"2862d6fc-d03d-4094-add6-13ca4bb41e97"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (709)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, 
   3.9611468224241905`*^9},ExpressionUUID->"6b632e8b-382d-f643-a3c0-\
ac7b50ef54bb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"709", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611483140758953`*^9, 3.9611483148990593`*^9}},
 CellLabel->
  "In[471]:=",ExpressionUUID->"a7180a4f-9eb4-a04a-bfce-b4422d19ce6f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148318525419*^9, 3.9614133000510387`*^9},
 CellLabel->
  "Out[472]=",ExpressionUUID->"d83999a6-9e1c-4b52-be6c-9a627e7ce524"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (711)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, 
   3.961146854272953*^9},ExpressionUUID->"e1e6393c-c974-944c-b999-\
10434245fe65"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"711", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148330556343*^9, 3.9611483311476994`*^9}},
 CellLabel->
  "In[473]:=",ExpressionUUID->"bd367e80-d6c9-ce49-8890-d49c4edd6d05"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148332771303*^9, 3.961413301086402*^9},
 CellLabel->
  "Out[474]=",ExpressionUUID->"74cb4d19-fa22-4ccb-b72a-4c0f87b484ff"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (713)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.9599133086121655`*^9}, 
   3.9611468785848923`*^9},ExpressionUUID->"7ddd36c4-4ca1-f448-aa10-\
a6e86581df13"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"713", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148352131752*^9, 3.961148352539118*^9}},
 CellLabel->
  "In[475]:=",ExpressionUUID->"aa1c90da-db1c-6741-a849-066e3f97aa89"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611483543328533`*^9, 3.961413301896409*^9},
 CellLabel->
  "Out[476]=",ExpressionUUID->"d33c0406-9ad3-46f3-8697-41d677017dc7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (715)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, 
   3.9611469011612015`*^9},ExpressionUUID->"f8617045-0e69-2d4f-9766-\
44373cc3978c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"715", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148367764494*^9, 3.961148368115469*^9}},
 CellLabel->
  "In[477]:=",ExpressionUUID->"f5f3d2b4-62f4-344f-8094-6644d9b2d73a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148370928753*^9, 3.961413305533136*^9},
 CellLabel->
  "Out[478]=",ExpressionUUID->"a5ede98c-86d5-4cbf-b06e-b37cbd643cd2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (717)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, 
   3.96114692105538*^9},ExpressionUUID->"127f9440-6690-634f-b6b7-\
0bae81336006"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"717", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611483844763966`*^9, 3.961148384644476*^9}},
 CellLabel->
  "In[479]:=",ExpressionUUID->"dbde6586-43f4-f145-96cd-da87b4cb426e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148386009783*^9, 3.961413306272368*^9},
 CellLabel->
  "Out[480]=",ExpressionUUID->"c02acfdb-d466-4cc0-809e-9f2667880dd1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (719)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913467251753*^9}, 
   3.961146946360281*^9},ExpressionUUID->"713a6344-3645-1c4d-9946-\
b7ddbe9efa7b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"719", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611484050992413`*^9, 3.9611484058118896`*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"7b359ed7-f152-814e-87a3-56e13139c9fe"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148411350155*^9, 3.9614133133543463`*^9},
 CellLabel->
  "Out[482]=",ExpressionUUID->"a54c4c02-b5ef-4c86-9d6c-edf2f9f2935f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (721)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, 3.961146986648203*^9, 
   3.961147079545866*^9, 
   3.9611484372819595`*^9},ExpressionUUID->"e6f3d849-0330-fa43-a61b-\
1189ac3a33ec"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"721", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611484267323074`*^9, 3.9611484272925987`*^9}},
 CellLabel->
  "In[483]:=",ExpressionUUID->"dcb5e978-d8da-7140-945a-9302debb32b6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611484302250633`*^9, 3.961413315341086*^9},
 CellLabel->
  "Out[484]=",ExpressionUUID->"84624b98-2bc8-4bb5-9eea-6142fd8aa191"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (723)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913544717146*^9}, 
   3.961147002038124*^9},ExpressionUUID->"b99c4d27-dbfa-7849-83b6-\
fcdaff69693a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"723", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96114844876478*^9, 3.9611484493561897`*^9}},
 CellLabel->
  "In[485]:=",ExpressionUUID->"b255938f-f89b-2340-bfe4-14a3ceaaec3b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148464621004*^9, 3.9614133264724092`*^9},
 CellLabel->
  "Out[486]=",ExpressionUUID->"0c4fa7fc-435a-45b1-b284-7c54dcabbf5a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (725)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, 
   3.96114849801783*^9},ExpressionUUID->"9b64f1fd-5b2d-c74b-9772-\
b58475a458dc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"725", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611484798119545`*^9, 3.961148481539448*^9}},
 CellLabel->
  "In[487]:=",ExpressionUUID->"92f080d6-0e20-af48-802c-950f422c4f84"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611484848538*^9, 3.961413329224531*^9},
 CellLabel->
  "Out[488]=",ExpressionUUID->"b8bdd4ef-ab91-4322-aae1-450f6463a15b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (727)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, 
   3.9611472260571575`*^9},ExpressionUUID->"87996f95-e450-0d49-b0f2-\
48dd4b964a99"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"727", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148508531662*^9, 3.9611485089179688`*^9}},
 CellLabel->
  "In[489]:=",ExpressionUUID->"5ea3b98d-e204-9645-b166-af9f651c3611"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611485098684177`*^9, 3.961413329513465*^9},
 CellLabel->
  "Out[490]=",ExpressionUUID->"5f613961-e25f-49b7-aae4-d116285397ff"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (729)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.9599126130529404`*^9}, {3.9599127148106823`*^9, 
   3.9599127424235973`*^9}, {3.9599127959496765`*^9, 
   3.9599128512270584`*^9}, {3.959912890482128*^9, 3.9599129903225155`*^9}, {
   3.959913079347145*^9, 3.9599130907243385`*^9}, {3.9599131307551117`*^9, 
   3.9599131312751102`*^9}, {3.9599133017878075`*^9, 
   3.9599133351758575`*^9}, {3.959913376691412*^9, 3.9599133767044125`*^9}, {
   3.959913467187746*^9, 3.9599134757557545`*^9}, {3.9599135446787224`*^9, 
   3.9599135644674377`*^9}, {3.9599136186837063`*^9, 
   3.9599136187477055`*^9}, {3.9599136700445175`*^9, 3.959913670132557*^9}, 
   3.9599137268695087`*^9},ExpressionUUID->"1139ef0e-d0eb-1e4f-b36c-\
7fb5e4074fbb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"729", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611486012847424`*^9, 3.961148602419449*^9}},
 CellLabel->
  "In[491]:=",ExpressionUUID->"3769e49d-fb11-794e-8d6d-6dbf96564f70"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611486032495384`*^9, 3.96141332969164*^9},
 CellLabel->
  "Out[492]=",ExpressionUUID->"af934c6e-75a0-4875-a916-2ea14932bd65"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (731)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, 
   3.9611472786328583`*^9},ExpressionUUID->"38a301c5-2b3b-bb40-8fb4-\
1716c65be2fb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"731", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611486308282795`*^9, 3.9611486313015747`*^9}},
 CellLabel->
  "In[493]:=",ExpressionUUID->"9141d29b-475c-2549-bf2f-dfd47653c8ec"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611486321405334`*^9, 3.961413329982003*^9},
 CellLabel->
  "Out[494]=",ExpressionUUID->"00e72014-e59d-44aa-8cf7-bf62f25beff5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (733)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, 
   3.961147304009037*^9},ExpressionUUID->"300fee23-5a48-2747-ac21-\
3b68b467248c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"733", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148642629545*^9, 3.961148643227682*^9}},
 CellLabel->
  "In[495]:=",ExpressionUUID->"dc85d0b3-6c6a-6e41-af3b-b946168fe6c4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611486442697105`*^9, 3.9614133307404947`*^9},
 CellLabel->
  "Out[496]=",ExpressionUUID->"7ab7f2d9-7abb-4039-8fd2-5d242bfe1722"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (735)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, 
   3.9611473340658455`*^9},ExpressionUUID->"01c6c4bf-284f-694a-9be6-\
3aaadd6e2ef1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"735", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148651724209*^9, 3.961148653373108*^9}},
 CellLabel->
  "In[497]:=",ExpressionUUID->"f686f7ad-7bab-e64c-bd45-90eedc92a5b0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148654202585*^9, 3.9614133312217503`*^9},
 CellLabel->
  "Out[498]=",ExpressionUUID->"1a648cce-1196-426d-9ea7-731a90259a0b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (737)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.9599126130529404`*^9}, {3.9599127148106823`*^9, 
   3.9599127424235973`*^9}, {3.9599127959496765`*^9, 
   3.9599128512270584`*^9}, {3.959912890482128*^9, 3.9599129903225155`*^9}, {
   3.959913079347145*^9, 3.9599130907243385`*^9}, {3.9599131307551117`*^9, 
   3.9599131312751102`*^9}, {3.9599133017878075`*^9, 
   3.9599133351758575`*^9}, {3.959913376691412*^9, 3.9599133767044125`*^9}, {
   3.959913467187746*^9, 3.9599134757557545`*^9}, {3.9599135446787224`*^9, 
   3.9599135644674377`*^9}, {3.9599136186837063`*^9, 
   3.9599136187477055`*^9}, {3.9599136700445175`*^9, 3.959913670132557*^9}, {
   3.9599137034067726`*^9, 3.9599137040817432`*^9}, {3.9599137483398457`*^9, 
   3.959913748420883*^9}, {3.959913799836853*^9, 3.959913799916853*^9}, {
   3.959915490545784*^9, 3.9599154906002293`*^9}, 
   3.9599155446084423`*^9},ExpressionUUID->"c40d17f3-03c4-684a-a3de-\
c9f349073be5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"737", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611486879567337`*^9, 3.9611486884201336`*^9}},
 CellLabel->
  "In[499]:=",ExpressionUUID->"6c754767-1de9-fa45-b807-4f8bd4c89074"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611486894182415`*^9, 3.961413331499035*^9},
 CellLabel->
  "Out[500]=",ExpressionUUID->"7adde24d-7a6a-49b2-b13e-6e41a172c704"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (739)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, 
   3.9611473818694744`*^9},ExpressionUUID->"31f794f8-0b87-8143-8b88-\
317579c22adb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"739", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611487012206364`*^9, 3.961148702579857*^9}},
 CellLabel->
  "In[501]:=",ExpressionUUID->"45f9b0c7-ac17-7143-ab0b-d3d0f71b41a6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611487035674305`*^9, 3.96141333193322*^9},
 CellLabel->
  "Out[502]=",ExpressionUUID->"598717c3-756b-4ad2-b50d-e44fbd008bb7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (741)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, 
   3.961147403465534*^9},ExpressionUUID->"c451b77c-53ac-674f-9c50-\
0e373c19a5d6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"741", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611487159476814`*^9, 3.9611487164194984`*^9}},
 CellLabel->
  "In[503]:=",ExpressionUUID->"4d12649c-c66e-4743-9b1c-b4d8d6f102c9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611487188993816`*^9, 3.9614133348323603`*^9},
 CellLabel->
  "Out[504]=",ExpressionUUID->"c923b8b2-a357-4b53-9b28-b1aa99786c08"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (743)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, 
   3.961148757025202*^9},ExpressionUUID->"11bece52-2912-9d43-a10e-\
c881614b9a39"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"743", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611487298772926`*^9, 3.961148730411894*^9}},
 CellLabel->
  "In[505]:=",ExpressionUUID->"d1903be5-5303-414a-be6e-ac11ead18e60"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611487318976803`*^9, 3.961413335645995*^9},
 CellLabel->
  "Out[506]=",ExpressionUUID->"ecc2a27b-c65f-4652-8fe9-32a8d1101339"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (745)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.9599157224739857`*^9}, 
   3.961147515985779*^9},ExpressionUUID->"6802181b-e72e-ea4f-b2b2-\
8dc1d6922c73"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"745", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148764764267*^9, 3.961148765381399*^9}},
 CellLabel->
  "In[507]:=",ExpressionUUID->"02d23c76-a49b-5e45-a549-27c694978224"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611487714885445`*^9, 3.9614133432698097`*^9},
 CellLabel->
  "Out[508]=",ExpressionUUID->"7dc2801c-16c1-423d-bec5-70f6959b90e3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (747)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, 
   3.961148789051182*^9},ExpressionUUID->"1d764615-75c3-fe48-9e78-\
eb090dfd4057"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"747", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148782340822*^9, 3.961148783303646*^9}},
 CellLabel->
  "In[509]:=",ExpressionUUID->"e4c8b1e3-f919-f84a-8d76-6e0a2fc35132"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611487854339237`*^9, 3.9614133445664454`*^9},
 CellLabel->
  "Out[510]=",ExpressionUUID->"7c9799be-e4f5-42c4-9e1c-49a20697534e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (753)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, 
   3.9611476253136406`*^9},ExpressionUUID->"fdd20473-86e7-8843-8d32-\
de024e98e3d5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"753", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611488436930485`*^9, 3.96114884442066*^9}},
 CellLabel->
  "In[511]:=",ExpressionUUID->"fff64508-a70d-f645-9eca-71af4670ee6b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148845762781*^9, 3.9614133449439163`*^9},
 CellLabel->
  "Out[512]=",ExpressionUUID->"86018ef8-8308-4316-914f-e4c13755e606"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (755)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, 
   3.959915980273166*^9},ExpressionUUID->"33d41e51-828b-6044-a6f9-\
bd0aa479d079"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"755", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961148873492529*^9, 3.9611488740280323`*^9}},
 CellLabel->
  "In[513]:=",ExpressionUUID->"7786e9f9-4802-7d43-871f-cc2353fc28b5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611488748228893`*^9, 3.961413345110921*^9},
 CellLabel->
  "Out[514]=",ExpressionUUID->"d8e02ec3-0fb9-42c5-adb3-afbb50f7a37e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (759)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.9599159921224785`*^9}, 
   3.961147677984953*^9},ExpressionUUID->"5d1dc4d6-cdc0-864c-bba8-\
602f8331245c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X759", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"759", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X759", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961147661723999*^9, 3.961147670787649*^9}},
 CellLabel->
  "In[515]:=",ExpressionUUID->"84aa7a30-9f8a-124d-914f-df1b9589c9cd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611476725427685`*^9, 3.961413346273755*^9},
 CellLabel->
  "Out[517]=",ExpressionUUID->"08c9e370-1bfa-42f2-b5a3-5bffeec0ca10"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (761)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, 
   3.961147705307127*^9},ExpressionUUID->"aa3866c6-4311-5948-9a9f-\
dd00cffc6084"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"761", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611489022596645`*^9, 3.961148902572233*^9}},
 CellLabel->
  "In[518]:=",ExpressionUUID->"b716663b-e456-ff48-a8c9-ed9697c71e4e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611489043615894`*^9, 3.961413348962627*^9},
 CellLabel->
  "Out[519]=",ExpressionUUID->"cdced44a-c975-4bab-81ae-37ca5a08136c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (767)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, 
   3.9611477327772007`*^9},ExpressionUUID->"4f0a0ac1-5627-e841-98ee-\
69ce2ecb1596"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"767", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611489150765915`*^9, 3.961148915403988*^9}},
 CellLabel->
  "In[520]:=",ExpressionUUID->"c22cd57e-af18-904e-885f-645fdf8ac97f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611489171448536`*^9, 3.9614133503033447`*^9},
 CellLabel->
  "Out[521]=",ExpressionUUID->"a04b9570-fd10-4f6a-9a30-609ecfc33231"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (840)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, 
   3.961147766849018*^9},ExpressionUUID->"2b9ebe7a-b725-284a-a406-\
a159b6cd313c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"840", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611489277645473`*^9, 3.961148928668314*^9}},
 CellLabel->
  "In[522]:=",ExpressionUUID->"9883f6c6-28ee-f24d-93f3-4f8a177cf1c2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961148930004566*^9, 3.961413350983337*^9},
 CellLabel->
  "Out[523]=",ExpressionUUID->"33d692b4-af39-48da-8aaf-845ca3de442e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (841)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.9599126130529404`*^9}, {3.9599127148106823`*^9, 
   3.9599127424235973`*^9}, {3.9599127959496765`*^9, 
   3.9599128512270584`*^9}, {3.959912890482128*^9, 3.9599129903225155`*^9}, {
   3.959913079347145*^9, 3.9599130907243385`*^9}, {3.9599131307551117`*^9, 
   3.9599131312751102`*^9}, {3.9599133017878075`*^9, 
   3.9599133351758575`*^9}, {3.959913376691412*^9, 3.9599133767044125`*^9}, {
   3.959913467187746*^9, 3.9599134757557545`*^9}, {3.9599135446787224`*^9, 
   3.9599135644674377`*^9}, {3.9599136186837063`*^9, 
   3.9599136187477055`*^9}, {3.9599136700445175`*^9, 3.959913670132557*^9}, {
   3.9599137034067726`*^9, 3.9599137040817432`*^9}, {3.9599137483398457`*^9, 
   3.959913748420883*^9}, {3.959913799836853*^9, 3.959913799916853*^9}, {
   3.959915490545784*^9, 3.9599154906002293`*^9}, {3.959915521485609*^9, 
   3.959915521565607*^9}, {3.959915566213703*^9, 3.9599155670060863`*^9}, {
   3.9599156192543945`*^9, 3.9599156193183613`*^9}, {3.959915680070671*^9, 
   3.9599156801496754`*^9}, {3.9599157224620247`*^9, 3.959915748535074*^9}, {
   3.9599157966865063`*^9, 3.9599157974535103`*^9}, {3.9599159285029945`*^9, 
   3.959915928590975*^9}, {3.95991599203257*^9, 3.959916019990164*^9}, {
   3.9599160608151646`*^9, 3.959916060863165*^9}, {3.959916104407284*^9, 
   3.9599161053032837`*^9}, {3.9599161652710876`*^9, 3.9599161652940845`*^9}, 
   3.959916227466076*^9},ExpressionUUID->"7d82f464-cacf-1244-b4e4-\
5f92b0ec2e40"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X841", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"841", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X841", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611477826680355`*^9, 3.961147792102108*^9}},
 CellLabel->
  "In[524]:=",ExpressionUUID->"a959bcf2-3126-7044-8e67-5a6a6e1bd221"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611477940569477`*^9, 3.961149024120739*^9, 
  3.96141335225245*^9},
 CellLabel->
  "Out[526]=",ExpressionUUID->"27cfa1d5-782c-4172-8f76-750bd2d774b5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (842)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429623`*^9, 3.959910694900997*^9}, {
   3.9599107915650616`*^9, 3.9599107917149734`*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.9599120799401684`*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.9599123105948677`*^9, 3.9599123284108486`*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.9599124891428585`*^9, 
   3.9599124909405975`*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.9599126130529404`*^9}, {3.9599127148106823`*^9, 
   3.9599127424235973`*^9}, {3.9599127959496765`*^9, 
   3.9599128512270584`*^9}, {3.959912890482128*^9, 3.9599129903225155`*^9}, {
   3.959913079347145*^9, 3.9599130907243385`*^9}, {3.9599131307551117`*^9, 
   3.9599131312751102`*^9}, {3.9599133017878075`*^9, 
   3.9599133351758575`*^9}, {3.959913376691412*^9, 3.9599133767044125`*^9}, {
   3.959913467187746*^9, 3.9599134757557545`*^9}, {3.9599135446787224`*^9, 
   3.9599135644674377`*^9}, {3.9599136186837063`*^9, 
   3.9599136187477055`*^9}, {3.9599136700445175`*^9, 3.959913670132557*^9}, {
   3.9599137034067726`*^9, 3.9599137040817432`*^9}, {3.9599137483398457`*^9, 
   3.959913748420883*^9}, {3.959913799836853*^9, 3.959913799916853*^9}, {
   3.959915490545784*^9, 3.9599154906002293`*^9}, {3.959915521485609*^9, 
   3.959915521565607*^9}, {3.959915566213703*^9, 3.9599155670060863`*^9}, {
   3.9599156192543945`*^9, 3.9599156193183613`*^9}, {3.959915680070671*^9, 
   3.9599156801496754`*^9}, {3.9599157224620247`*^9, 3.959915748535074*^9}, {
   3.9599157966865063`*^9, 3.9599157974535103`*^9}, {3.9599159285029945`*^9, 
   3.959915928590975*^9}, {3.95991599203257*^9, 3.959916019990164*^9}, {
   3.9599160608151646`*^9, 3.959916060863165*^9}, {3.959916104407284*^9, 
   3.9599161053032837`*^9}, {3.9599161652710876`*^9, 
   3.9599161652940845`*^9}, {3.959916227466076*^9, 
   3.9599162374516506`*^9}},ExpressionUUID->"b6afe295-63a0-3b41-99c8-\
12b973f6bf47"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X842", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"842", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X842", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611478099005337`*^9, 3.9611478212836037`*^9}},
 CellLabel->
  "In[527]:=",ExpressionUUID->"5be977ff-2af0-254c-aa62-7489f0a14129"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961147822696556*^9, 3.9611490791487617`*^9, 
  3.961413352642994*^9},
 CellLabel->
  "Out[529]=",ExpressionUUID->"1d70dd39-9055-473e-9301-5ac06bffffc2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (843)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, {
   3.959916165271087*^9, 3.959916165294084*^9}, {3.959916227466076*^9, 
   3.959916259859585*^9}},ExpressionUUID->"1cb24f33-8dc5-2449-8448-\
951b6e95b0c9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X843", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"843", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X843", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9611478347956696`*^9, 3.9611478441870537`*^9}},
 CellLabel->
  "In[530]:=",ExpressionUUID->"2334dd70-7bdf-4046-a95c-e8fab005d84a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611478451151276`*^9, 3.9611490945281925`*^9, 
  3.961413352819056*^9},
 CellLabel->
  "Out[532]=",ExpressionUUID->"1426765b-b037-420d-bd71-15472baf3c82"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (915)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, {
   3.959916165271087*^9, 3.959916165294084*^9}, {3.959916227466076*^9, 
   3.959916259859585*^9}, {3.9599163063543034`*^9, 3.959916306826491*^9}, 
   3.959916355847233*^9, 
   3.9611478895455017`*^9},ExpressionUUID->"d41c1b18-0d68-d44e-8cdd-\
81aad9134881"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X915", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"915", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X915", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961147858587721*^9, 3.961147872156229*^9}},
 CellLabel->
  "In[533]:=",ExpressionUUID->"4c6ce1bc-8489-1a4e-9a83-9b5dd1e6f967"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961147884953203*^9, 3.9611491192205467`*^9, 
  3.961413373230741*^9},
 CellLabel->
  "Out[535]=",ExpressionUUID->"cefbc117-6e9a-495a-9d52-168555b51e19"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (917)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, {
   3.959916165271087*^9, 3.959916165294084*^9}, {3.959916227466076*^9, 
   3.959916259859585*^9}, {3.9599163063543034`*^9, 3.959916306826491*^9}, {
   3.959916343319233*^9, 3.959916343351244*^9}, 3.959916438143579*^9, 
   3.961147931305441*^9},ExpressionUUID->"050723f8-f06a-2d46-8937-\
4f741fd249c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X917", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"917", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X917", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96114790356394*^9, 3.9611479121961975`*^9}},
 CellLabel->
  "In[536]:=",ExpressionUUID->"849267a7-be37-f744-a433-e61b424d71d6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611479262007694`*^9, 3.961149187832266*^9, 
  3.9614133953663397`*^9},
 CellLabel->
  "Out[538]=",ExpressionUUID->"3d820b2a-6b04-4d1a-9d1a-b59addb531d4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (953)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, {
   3.959916165271087*^9, 3.959916165294084*^9}, {3.959916227466076*^9, 
   3.959916259859585*^9}, {3.9599163063543034`*^9, 3.959916306826491*^9}, {
   3.959916343319233*^9, 3.959916343351244*^9}, {3.9599163933275623`*^9, 
   3.959916394614567*^9}, 3.959916518439638*^9, 
   3.961147977906233*^9},ExpressionUUID->"ffa31bcf-3487-2b43-afdf-\
322d9e74ae79"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X953", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"ETC", "[", 
      RowBox[{"[", 
       RowBox[{"953", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X953", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961147948332165*^9, 3.961147963020439*^9}},
 CellLabel->
  "In[539]:=",ExpressionUUID->"87f297b1-2d0b-d147-b524-e1b623e0f7ca"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611479760957565`*^9, 3.9611492016713047`*^9, 
  3.961413415886941*^9},
 CellLabel->
  "Out[541]=",ExpressionUUID->"a248b724-3095-419e-99e4-e02a85a111d6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (972)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.9599106948429627`*^9, 3.959910694900997*^9}, {
   3.959910791565061*^9, 3.959910791714974*^9}, {3.959911965534733*^9, 
   3.959911965957279*^9}, {3.959912079940168*^9, 3.959912095029068*^9}, 
   3.9599122602741547`*^9, {3.959912310594867*^9, 3.959912328410848*^9}, {
   3.9599123586262836`*^9, 3.9599123785699596`*^9}, {3.959912489142858*^9, 
   3.959912490940597*^9}, 3.959912570081772*^9, {3.959912611596979*^9, 
   3.95991261305294*^9}, {3.9599127148106823`*^9, 3.959912742423598*^9}, {
   3.9599127959496765`*^9, 3.959912851227059*^9}, {3.959912890482128*^9, 
   3.959912990322515*^9}, {3.959913079347145*^9, 3.9599130907243385`*^9}, {
   3.959913130755111*^9, 3.95991313127511*^9}, {3.9599133017878075`*^9, 
   3.959913335175857*^9}, {3.959913376691412*^9, 3.959913376704413*^9}, {
   3.959913467187746*^9, 3.959913475755754*^9}, {3.9599135446787224`*^9, 
   3.959913564467438*^9}, {3.9599136186837063`*^9, 3.9599136187477055`*^9}, {
   3.9599136700445175`*^9, 3.959913670132557*^9}, {3.9599137034067726`*^9, 
   3.959913704081743*^9}, {3.9599137483398457`*^9, 3.959913748420883*^9}, {
   3.959913799836853*^9, 3.959913799916853*^9}, {3.959915490545784*^9, 
   3.9599154906002283`*^9}, {3.959915521485609*^9, 3.959915521565607*^9}, {
   3.959915566213703*^9, 3.959915567006087*^9}, {3.959915619254394*^9, 
   3.959915619318361*^9}, {3.959915680070671*^9, 3.959915680149675*^9}, {
   3.959915722462025*^9, 3.959915748535074*^9}, {3.9599157966865067`*^9, 
   3.9599157974535103`*^9}, {3.9599159285029945`*^9, 3.959915928590975*^9}, {
   3.95991599203257*^9, 3.959916019990164*^9}, {3.959916060815164*^9, 
   3.959916060863165*^9}, {3.959916104407284*^9, 3.959916105303283*^9}, {
   3.959916165271087*^9, 3.959916165294084*^9}, {3.959916227466076*^9, 
   3.959916259859585*^9}, {3.9599163063543034`*^9, 3.959916306826491*^9}, {
   3.959916343319233*^9, 3.959916343351244*^9}, {3.9599163933275623`*^9, 
   3.959916394614567*^9}, {3.9599164558316307`*^9, 3.9599164565036163`*^9}, 
   3.959916522607641*^9, 
   3.961148019249338*^9},ExpressionUUID->"420dad99-a90e-e04e-b4b3-\
bff1db226ff3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"972", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonPerpendiculares", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptF"}], "]"}]}], "]"}], ",", "ortho"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.961149243117647*^9, 3.9611492443402786`*^9}},
 CellLabel->
  "In[542]:=",ExpressionUUID->"1521c2bd-bd5c-0945-83ab-53525106548e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611492548670006`*^9, 3.961413424235973*^9},
 CellLabel->
  "Out[543]=",ExpressionUUID->"687bf346-3aab-4872-b79b-5f5c0879374a"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{235, Automatic}, {Automatic, 72}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"76d97bea-5068-2d4f-9c92-6b3a031dec9a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 492, 7, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1075, 31, 1539, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2639, 61, 200, 4, 66, "Section",ExpressionUUID->"9f6088f9-a2be-3140-964a-e41e398b8645"],
Cell[CellGroupData[{
Cell[2864, 69, 3202, 74, 194, "Input",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],
Cell[6069, 145, 740, 21, 70, "Output",ExpressionUUID->"5f6fa53c-439b-44f9-a380-21d5d5d422ca"],
Cell[6812, 168, 646, 17, 70, "Output",ExpressionUUID->"123aab62-bdab-4bdb-8a4b-18d9bc010755"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7507, 191, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[7765, 197, 9012, 236, 544, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[16814, 438, 356, 6, 52, "Section",ExpressionUUID->"3cbb4941-f491-e944-a1fa-7bd4c19f5af3"],
Cell[17173, 446, 35793, 592, 150, "Text",ExpressionUUID->"a44dd8ce-716c-ff47-b686-3d356d61de25"],
Cell[CellGroupData[{
Cell[52991, 1042, 791, 14, 29, "Input",ExpressionUUID->"24c0694c-7ce6-5a4a-a7ef-49ffd3a8021d"],
Cell[53785, 1058, 861, 28, 35, "Output",ExpressionUUID->"7281f5e7-eaf0-4268-b269-c1e7dfdf698c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54695, 1092, 157, 3, 66, "Section",ExpressionUUID->"533a37db-4bf4-c049-b2cf-748105802c1b"],
Cell[CellGroupData[{
Cell[54877, 1099, 585, 8, 53, "Subsection",ExpressionUUID->"1254f18b-db3a-2d45-9037-02c91cd4cbbc"],
Cell[55465, 1109, 475, 7, 31, "Text",ExpressionUUID->"e4f23084-35ad-8447-a2e8-950e78b432d0"]
}, Closed]],
Cell[CellGroupData[{
Cell[55977, 1121, 475, 7, 37, "Subsection",ExpressionUUID->"f450e165-3fe4-bb4e-a74a-07f6cc214c8b"],
Cell[CellGroupData[{
Cell[56477, 1132, 886, 19, 43, "Input",ExpressionUUID->"a8d42ec2-059d-c243-b392-16ec74ba5058"],
Cell[57366, 1153, 672, 11, 70, "Output",ExpressionUUID->"65be21cc-17bd-4acd-bf34-71c132d19b5f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58087, 1170, 527, 8, 37, "Subsection",ExpressionUUID->"bea0bf56-1c20-f04b-8dac-70e8e7d696e3"],
Cell[CellGroupData[{
Cell[58639, 1182, 791, 18, 49, "Input",ExpressionUUID->"c646ccab-f488-1649-bcfb-b88a2ce46760"],
Cell[59433, 1202, 376, 7, 33, "Output",ExpressionUUID->"6537f68b-a366-4cb3-8b66-ffb0a22a37dc"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59858, 1215, 649, 10, 37, "Subsection",ExpressionUUID->"c1e1f6cc-d884-644d-94a7-d95785ef3f56"],
Cell[CellGroupData[{
Cell[60532, 1229, 547, 14, 49, "Input",ExpressionUUID->"cba32ffa-8174-7249-83a3-614233702119"],
Cell[61082, 1245, 177, 3, 33, "Output",ExpressionUUID->"e85e9d4f-e255-4456-943e-b07a29869bbe"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61308, 1254, 674, 10, 37, "Subsection",ExpressionUUID->"e584b43c-491d-ce46-b522-e13074723ba3"],
Cell[CellGroupData[{
Cell[62007, 1268, 545, 14, 49, "Input",ExpressionUUID->"a8af9933-d29a-aa4c-9ce2-05e684bcb4de"],
Cell[62555, 1284, 180, 3, 33, "Output",ExpressionUUID->"8d201a75-45b2-48ff-a5a0-4b2a65271d3d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62784, 1293, 576, 9, 37, "Subsection",ExpressionUUID->"16a51a0e-fbcc-b94b-9131-8ce8b8b4b133"],
Cell[CellGroupData[{
Cell[63385, 1306, 837, 18, 43, "Input",ExpressionUUID->"7a1a86b9-f66e-424f-ab17-68735df15c97"],
Cell[64225, 1326, 379, 7, 70, "Output",ExpressionUUID->"26686a44-be8d-4929-97be-7cd25a3b4b0a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64653, 1339, 767, 11, 37, "Subsection",ExpressionUUID->"583236b4-0e1c-d248-84b6-1eb97e5315c6"],
Cell[CellGroupData[{
Cell[65445, 1354, 1251, 29, 60, "Input",ExpressionUUID->"03fde7ca-7e12-404f-a91f-ed5b80ae69b3"],
Cell[66699, 1385, 529, 9, 70, "Output",ExpressionUUID->"03920aa8-8cfb-4c45-ba1e-5056d737bf93"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67277, 1400, 748, 11, 37, "Subsection",ExpressionUUID->"dd86b5f2-8cad-f440-8230-698e7bd59518"],
Cell[CellGroupData[{
Cell[68050, 1415, 1127, 27, 60, "Input",ExpressionUUID->"c3629827-eae7-294d-b29c-1d848a2d2079"],
Cell[69180, 1444, 402, 7, 70, "Output",ExpressionUUID->"0df3e899-1026-412c-bc3c-765c2635564d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69631, 1457, 622, 9, 37, "Subsection",ExpressionUUID->"0324d82f-1439-9c4d-b70f-a91e07cd4dc6"],
Cell[CellGroupData[{
Cell[70278, 1470, 915, 19, 43, "Input",ExpressionUUID->"a1466a81-6ddb-a443-aa00-826f51c37fd0"],
Cell[71196, 1491, 378, 7, 70, "Output",ExpressionUUID->"e6b011e4-d025-4aec-a84f-2ed23fa1ba5b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71623, 1504, 672, 10, 37, "Subsection",ExpressionUUID->"9e26f302-098c-b74d-b3cb-e544cbe68b2a"],
Cell[CellGroupData[{
Cell[72320, 1518, 781, 22, 70, "Input",ExpressionUUID->"bdf02d03-b236-7344-b34a-0f328e737114"],
Cell[73104, 1542, 178, 3, 33, "Output",ExpressionUUID->"43fe9452-aa97-41ab-bcb1-0bcb97f45f1f"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73343, 1552, 264, 4, 52, "Section",ExpressionUUID->"38350a6d-5fe1-314f-b6b7-2ebc74453d7a"],
Cell[73610, 1558, 34702, 573, 272, "Text",ExpressionUUID->"7e42d067-23c5-fd44-b1b1-ad22f03b076f"],
Cell[CellGroupData[{
Cell[108337, 2135, 622, 9, 53, "Subsection",ExpressionUUID->"cc794e42-092d-0e46-9a3a-f415d61346d6"],
Cell[CellGroupData[{
Cell[108984, 2148, 2298, 64, 129, "Input",ExpressionUUID->"f8da1f3c-f77c-c94e-ad6c-9bc93b46609c"],
Cell[111285, 2214, 325, 5, 70, "Output",ExpressionUUID->"e4fbd796-7ffe-4938-a81a-c783ade76de9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[111659, 2225, 574, 9, 37, "Subsection",ExpressionUUID->"968e4dfa-298c-0548-91fc-0a1085d64484"],
Cell[CellGroupData[{
Cell[112258, 2238, 2249, 63, 129, "Input",ExpressionUUID->"63abb9a1-e6a4-a548-a3bb-13b02bc5d9e1"],
Cell[114510, 2303, 279, 5, 70, "Output",ExpressionUUID->"10cc25b7-813a-4584-8bf0-fbc2677f09e8"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[114838, 2314, 677, 10, 37, "Subsection",ExpressionUUID->"5e344956-7723-fb49-b657-3d66bf0356a0"],
Cell[CellGroupData[{
Cell[115540, 2328, 2253, 63, 129, "Input",ExpressionUUID->"49ee31df-9955-a649-8536-3ca507ad9f86"],
Cell[117796, 2393, 281, 5, 70, "Output",ExpressionUUID->"eb885fed-0024-4be8-bab6-2c6d26b5b2ae"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118126, 2404, 677, 10, 37, "Subsection",ExpressionUUID->"9ff4b1d7-e1c5-7546-ac5a-7f2d3f7bcea4"],
Cell[CellGroupData[{
Cell[118828, 2418, 2110, 61, 151, "Input",ExpressionUUID->"ee79f7a1-38e5-874a-8058-5e2c86d96d6e"],
Cell[120941, 2481, 175, 3, 33, "Output",ExpressionUUID->"f620facc-6922-49b9-9143-cdfbeb75c514"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[121165, 2490, 729, 11, 37, "Subsection",ExpressionUUID->"53bceed0-9e99-0342-b145-1959731f4015"],
Cell[121897, 2503, 436, 10, 55, "Text",ExpressionUUID->"7ed96f33-7dbc-754d-a859-1575b76fb14c"],
Cell[CellGroupData[{
Cell[122358, 2517, 2199, 63, 151, "Input",ExpressionUUID->"a0a81fd9-0ff2-6a41-994b-6071d4308ae8"],
Cell[124560, 2582, 228, 4, 33, "Output",ExpressionUUID->"402aebac-590f-47c0-92ca-7d517cd6b34e"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[124849, 2593, 259, 4, 52, "Section",ExpressionUUID->"ac27efec-3713-4e45-aca2-9089e1a79c3f"],
Cell[125111, 2599, 38908, 643, 300, "Text",ExpressionUUID->"efb7d5a2-9d81-4c4e-9ced-822dcb5e3185"],
Cell[164022, 3244, 539, 11, 77, "Text",ExpressionUUID->"802b14b4-b634-0949-9b05-85ca74b37d8b"],
Cell[CellGroupData[{
Cell[164586, 3259, 527, 8, 53, "Subsection",ExpressionUUID->"cbecca4b-1afc-0941-9b3a-241a5a1f2ec9"],
Cell[CellGroupData[{
Cell[165138, 3271, 1007, 23, 49, "Input",ExpressionUUID->"ad88972e-1c9b-6944-9aa3-9d5d2f872d16"],
Cell[166148, 3296, 180, 3, 33, "Output",ExpressionUUID->"48b97a94-cb35-41aa-97c3-0f1fccfa2d16"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166377, 3305, 583, 9, 37, "Subsection",ExpressionUUID->"34f4d9b9-45b2-1c4f-bf42-dfd3ce95a916"],
Cell[CellGroupData[{
Cell[166985, 3318, 446, 12, 29, "Input",ExpressionUUID->"dd28dea8-4c4a-5749-935a-21b580c8fa35"],
Cell[167434, 3332, 4565, 144, 80, "Output",ExpressionUUID->"4ccbf67e-b860-4a9e-b054-577135411de0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172036, 3481, 1105, 24, 49, "Input",ExpressionUUID->"a7828c3c-f3b5-f94a-9149-60c06a329207"],
Cell[173144, 3507, 203, 4, 33, "Output",ExpressionUUID->"3f47dd00-6784-4011-a417-419aeb293366"]
}, Open  ]],
Cell[173362, 3514, 923, 18, 71, "Text",ExpressionUUID->"f4a8ad7b-da6e-604a-bc93-45b9301a659c"]
}, Closed]],
Cell[CellGroupData[{
Cell[174322, 3537, 628, 9, 37, "Subsection",ExpressionUUID->"076fc163-5c9c-e44f-a8ef-ecc9b7615e78"],
Cell[CellGroupData[{
Cell[174975, 3550, 1154, 25, 43, "Input",ExpressionUUID->"1b0dcbf0-60a1-ac47-82a4-9a7a8b08775a"],
Cell[176132, 3577, 251, 4, 70, "Output",ExpressionUUID->"dedd1013-d52a-4110-a811-d61ad4fc3a40"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[176432, 3587, 680, 10, 37, "Subsection",ExpressionUUID->"864c518f-92bf-0041-b77b-ffc37f71a77f"],
Cell[CellGroupData[{
Cell[177137, 3601, 1152, 25, 43, "Input",ExpressionUUID->"5d797067-6414-8945-9820-353c14e015bb"],
Cell[178292, 3628, 278, 5, 70, "Output",ExpressionUUID->"54311648-da73-4a26-9379-df100805dd59"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[178619, 3639, 725, 11, 37, "Subsection",ExpressionUUID->"5a50ba19-57c9-3449-b4f7-3eccc51ee319"],
Cell[CellGroupData[{
Cell[179369, 3654, 1157, 25, 43, "Input",ExpressionUUID->"c530beb9-e8cd-244a-bf85-4afef3ee0d43"],
Cell[180529, 3681, 295, 5, 70, "Output",ExpressionUUID->"e022a84f-fc7f-454a-82b9-f783c065c6a3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[180873, 3692, 773, 11, 37, "Subsection",ExpressionUUID->"1fc764e1-24b4-a544-ae1d-aaaae38970fe"],
Cell[CellGroupData[{
Cell[181671, 3707, 1209, 26, 49, "Input",ExpressionUUID->"136ba42a-33f9-c54f-b64d-7fef60d92444"],
Cell[182883, 3735, 320, 5, 70, "Output",ExpressionUUID->"12c7d0aa-50ee-476b-b4f7-789eecc5f62d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[183252, 3746, 773, 11, 37, "Subsection",ExpressionUUID->"4d9164ba-bcf1-7d46-9bc4-c52e02336e07"],
Cell[CellGroupData[{
Cell[184050, 3761, 1208, 26, 43, "Input",ExpressionUUID->"cc569792-626a-7b42-80e4-8be5b917d63c"],
Cell[185261, 3789, 322, 5, 70, "Output",ExpressionUUID->"b17fe268-6809-4355-ba8a-71038c80f0a9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[185632, 3800, 825, 12, 37, "Subsection",ExpressionUUID->"43b94a0f-516c-2646-bdf8-cdc2e16c7a4d"],
Cell[CellGroupData[{
Cell[186482, 3816, 1251, 26, 49, "Input",ExpressionUUID->"aa964a52-06cb-0d42-98c6-447af230825a"],
Cell[187736, 3844, 318, 5, 33, "Output",ExpressionUUID->"1f66cf37-a771-4ac5-a78a-a995675a5637"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[188103, 3855, 827, 12, 37, "Subsection",ExpressionUUID->"9b9f6a84-59e6-f442-afcf-0d7cd4a5132a"],
Cell[CellGroupData[{
Cell[188955, 3871, 1254, 26, 43, "Input",ExpressionUUID->"344b3244-7e02-c942-b143-bdbbd2467004"],
Cell[190212, 3899, 320, 5, 70, "Output",ExpressionUUID->"21016768-8dbe-49b0-8f82-74c24a92723d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[190581, 3910, 863, 12, 37, "Subsection",ExpressionUUID->"b2765b9d-6311-794d-bb81-f6b4bffb23e4"],
Cell[CellGroupData[{
Cell[191469, 3926, 1304, 27, 43, "Input",ExpressionUUID->"d602a654-0d9d-5244-8b0c-d095d16e9061"],
Cell[192776, 3955, 347, 6, 70, "Output",ExpressionUUID->"15d8c6a3-e569-4319-9d3a-8bf5ad1ebaa9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[193172, 3967, 913, 13, 37, "Subsection",ExpressionUUID->"766dcc29-4b9f-5545-be17-9b2b3453ff31"],
Cell[CellGroupData[{
Cell[194110, 3984, 1590, 36, 60, "Input",ExpressionUUID->"0bc6a4ad-bfdb-6348-88ff-6edd22355ca0"],
Cell[195703, 4022, 453, 8, 70, "Output",ExpressionUUID->"a39cac49-c626-4f3e-8e89-51491bdda363"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[196205, 4036, 970, 14, 37, "Subsection",ExpressionUUID->"e656cafe-5be8-b84c-a27c-e1e2cbef63c8"],
Cell[CellGroupData[{
Cell[197200, 4054, 671, 18, 43, "Input",ExpressionUUID->"904deae3-1b5a-5446-ada0-7c7fde91af5d"],
Cell[197874, 4074, 182, 3, 70, "Output",ExpressionUUID->"e7e34ff3-d304-491b-85ce-4bee27daa6c7"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[198105, 4083, 1022, 15, 37, "Subsection",ExpressionUUID->"fb522d8b-c811-4d46-9f4c-ac47ce2e6912"],
Cell[CellGroupData[{
Cell[199152, 4102, 721, 19, 43, "Input",ExpressionUUID->"e5d79516-197c-c944-8278-e24ef3ad13de"],
Cell[199876, 4123, 207, 4, 70, "Output",ExpressionUUID->"66a84472-ac45-4ad5-9fc0-c6b28c302d03"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[200132, 4133, 996, 14, 37, "Subsection",ExpressionUUID->"7dab8625-c598-0540-b5cc-924e18ad05ee"],
Cell[CellGroupData[{
Cell[201153, 4151, 669, 18, 43, "Input",ExpressionUUID->"54d83243-3ffa-b047-a851-b94930168d3a"],
Cell[201825, 4171, 180, 3, 70, "Output",ExpressionUUID->"def4b540-e932-4827-aec1-dc9bb2217b98"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[202054, 4180, 1048, 15, 37, "Subsection",ExpressionUUID->"c0028e2e-feea-9242-8065-7114dbbcb1e2"],
Cell[CellGroupData[{
Cell[203127, 4199, 669, 18, 49, "Input",ExpressionUUID->"e4dfc51d-d737-5b47-9bae-b18b5227115c"],
Cell[203799, 4219, 180, 3, 70, "Output",ExpressionUUID->"a722850e-091a-43af-bcf1-74188c89ad25"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[204028, 4228, 1067, 15, 37, "Subsection",ExpressionUUID->"3a8e5026-d3dc-0e4b-a6eb-1930e7aa1872"],
Cell[CellGroupData[{
Cell[205120, 4247, 903, 26, 60, "Input",ExpressionUUID->"a91ff866-f35c-f446-8f9c-483e7302aa33"],
Cell[206026, 4275, 179, 3, 70, "Output",ExpressionUUID->"1b92ac39-280d-498b-ba66-b0b8c2dcffc0"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[206254, 4284, 1070, 15, 37, "Subsection",ExpressionUUID->"cc3e069e-3500-ea45-8ef9-c59abc9645b6"],
Cell[CellGroupData[{
Cell[207349, 4303, 905, 26, 60, "Input",ExpressionUUID->"c7b9e63d-2f61-5745-9c04-4b506520c63d"],
Cell[208257, 4331, 178, 3, 70, "Output",ExpressionUUID->"4aea6cb0-a107-49b5-ab3e-fa4acc9b81b4"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[208484, 4340, 1122, 16, 37, "Subsection",ExpressionUUID->"2f3c6052-f475-2d4a-a767-d0dc2a814ca1"],
Cell[CellGroupData[{
Cell[209631, 4360, 669, 18, 43, "Input",ExpressionUUID->"4a2447fc-3823-a34b-a1a6-c0f0f462a004"],
Cell[210303, 4380, 178, 3, 70, "Output",ExpressionUUID->"6c450976-bc29-4c45-a018-a828915b039f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[210530, 4389, 1120, 16, 37, "Subsection",ExpressionUUID->"1ffd9eb7-af51-264b-a1e1-ccf5a026b6dc"],
Cell[CellGroupData[{
Cell[211675, 4409, 671, 18, 43, "Input",ExpressionUUID->"daa197fc-2626-3846-a086-731ab76fd6d6"],
Cell[212349, 4429, 178, 3, 70, "Output",ExpressionUUID->"2862d6fc-d03d-4094-add6-13ca4bb41e97"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[212576, 4438, 1146, 16, 37, "Subsection",ExpressionUUID->"6b632e8b-382d-f643-a3c0-ac7b50ef54bb"],
Cell[CellGroupData[{
Cell[213747, 4458, 671, 18, 43, "Input",ExpressionUUID->"a7180a4f-9eb4-a04a-bfce-b4422d19ce6f"],
Cell[214421, 4478, 180, 3, 70, "Output",ExpressionUUID->"d83999a6-9e1c-4b52-be6c-9a627e7ce524"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[214650, 4487, 1193, 17, 37, "Subsection",ExpressionUUID->"e1e6393c-c974-944c-b999-10434245fe65"],
Cell[CellGroupData[{
Cell[215868, 4508, 669, 18, 43, "Input",ExpressionUUID->"bd367e80-d6c9-ce49-8890-d49c4edd6d05"],
Cell[216540, 4528, 178, 3, 70, "Output",ExpressionUUID->"74cb4d19-fa22-4ccb-b72a-4c0f87b484ff"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[216767, 4537, 1249, 18, 37, "Subsection",ExpressionUUID->"7ddd36c4-4ca1-f448-aa10-a6e86581df13"],
Cell[CellGroupData[{
Cell[218041, 4559, 667, 18, 43, "Input",ExpressionUUID->"aa1c90da-db1c-6741-a849-066e3f97aa89"],
Cell[218711, 4579, 180, 3, 70, "Output",ExpressionUUID->"d33c0406-9ad3-46f3-8697-41d677017dc7"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[218940, 4588, 1247, 18, 37, "Subsection",ExpressionUUID->"f8617045-0e69-2d4f-9766-44373cc3978c"],
Cell[CellGroupData[{
Cell[220212, 4610, 667, 18, 43, "Input",ExpressionUUID->"f5f3d2b4-62f4-344f-8094-6644d9b2d73a"],
Cell[220882, 4630, 178, 3, 70, "Output",ExpressionUUID->"a5ede98c-86d5-4cbf-b06e-b37cbd643cd2"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[221109, 4639, 1290, 18, 37, "Subsection",ExpressionUUID->"127f9440-6690-634f-b6b7-0bae81336006"],
Cell[CellGroupData[{
Cell[222424, 4661, 669, 18, 43, "Input",ExpressionUUID->"dbde6586-43f4-f145-96cd-da87b4cb426e"],
Cell[223096, 4681, 178, 3, 70, "Output",ExpressionUUID->"c02acfdb-d466-4cc0-809e-9f2667880dd1"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223323, 4690, 1341, 19, 37, "Subsection",ExpressionUUID->"713a6344-3645-1c4d-9946-b7ddbe9efa7b"],
Cell[CellGroupData[{
Cell[224689, 4713, 671, 18, 49, "Input",ExpressionUUID->"7b359ed7-f152-814e-87a3-56e13139c9fe"],
Cell[225363, 4733, 180, 3, 33, "Output",ExpressionUUID->"a54c4c02-b5ef-4c86-9d6c-edf2f9f2935f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[225592, 4742, 1391, 20, 37, "Subsection",ExpressionUUID->"e6f3d849-0330-fa43-a61b-1189ac3a33ec"],
Cell[CellGroupData[{
Cell[227008, 4766, 671, 18, 43, "Input",ExpressionUUID->"dcb5e978-d8da-7140-945a-9302debb32b6"],
Cell[227682, 4786, 180, 3, 70, "Output",ExpressionUUID->"84624b98-2bc8-4bb5-9eea-6142fd8aa191"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[227911, 4795, 1393, 20, 37, "Subsection",ExpressionUUID->"b99c4d27-dbfa-7849-83b6-fcdaff69693a"],
Cell[CellGroupData[{
Cell[229329, 4819, 668, 18, 43, "Input",ExpressionUUID->"b255938f-f89b-2340-bfe4-14a3ceaaec3b"],
Cell[230000, 4839, 180, 3, 70, "Output",ExpressionUUID->"0c4fa7fc-435a-45b1-b284-7c54dcabbf5a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[230229, 4848, 1392, 20, 37, "Subsection",ExpressionUUID->"9b64f1fd-5b2d-c74b-9772-b58475a458dc"],
Cell[CellGroupData[{
Cell[231646, 4872, 669, 18, 43, "Input",ExpressionUUID->"92f080d6-0e20-af48-802c-950f422c4f84"],
Cell[232318, 4892, 176, 3, 70, "Output",ExpressionUUID->"b8bdd4ef-ab91-4322-aae1-450f6463a15b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[232543, 4901, 1445, 20, 37, "Subsection",ExpressionUUID->"87996f95-e450-0d49-b0f2-48dd4b964a99"],
Cell[CellGroupData[{
Cell[234013, 4925, 669, 18, 43, "Input",ExpressionUUID->"5ea3b98d-e204-9645-b166-af9f651c3611"],
Cell[234685, 4945, 180, 3, 70, "Output",ExpressionUUID->"5f613961-e25f-49b7-aae4-d116285397ff"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[234914, 4954, 1537, 22, 37, "Subsection",ExpressionUUID->"1139ef0e-d0eb-1e4f-b36c-7fb5e4074fbb"],
Cell[CellGroupData[{
Cell[236476, 4980, 669, 18, 43, "Input",ExpressionUUID->"3769e49d-fb11-794e-8d6d-6dbf96564f70"],
Cell[237148, 5000, 179, 3, 70, "Output",ExpressionUUID->"af934c6e-75a0-4875-a916-2ea14932bd65"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237376, 5009, 1549, 22, 37, "Subsection",ExpressionUUID->"38a301c5-2b3b-bb40-8fb4-1716c65be2fb"],
Cell[CellGroupData[{
Cell[238950, 5035, 671, 18, 49, "Input",ExpressionUUID->"9141d29b-475c-2549-bf2f-dfd47653c8ec"],
Cell[239624, 5055, 180, 3, 70, "Output",ExpressionUUID->"00e72014-e59d-44aa-8cf7-bf62f25beff5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[239853, 5064, 1595, 22, 37, "Subsection",ExpressionUUID->"300fee23-5a48-2747-ac21-3b68b467248c"],
Cell[CellGroupData[{
Cell[241473, 5090, 667, 18, 43, "Input",ExpressionUUID->"dc85d0b3-6c6a-6e41-af3b-b946168fe6c4"],
Cell[242143, 5110, 182, 3, 70, "Output",ExpressionUUID->"7ab7f2d9-7abb-4039-8fd2-5d242bfe1722"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[242374, 5119, 1647, 23, 37, "Subsection",ExpressionUUID->"01c6c4bf-284f-694a-9be6-3aaadd6e2ef1"],
Cell[CellGroupData[{
Cell[244046, 5146, 667, 18, 43, "Input",ExpressionUUID->"f686f7ad-7bab-e64c-bd45-90eedc92a5b0"],
Cell[244716, 5166, 180, 3, 70, "Output",ExpressionUUID->"1a648cce-1196-426d-9ea7-731a90259a0b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[244945, 5175, 1741, 25, 37, "Subsection",ExpressionUUID->"c40d17f3-03c4-684a-a3de-c9f349073be5"],
Cell[CellGroupData[{
Cell[246711, 5204, 671, 18, 49, "Input",ExpressionUUID->"6c754767-1de9-fa45-b807-4f8bd4c89074"],
Cell[247385, 5224, 180, 3, 33, "Output",ExpressionUUID->"7adde24d-7a6a-49b2-b13e-6e41a172c704"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[247614, 5233, 1745, 24, 37, "Subsection",ExpressionUUID->"31f794f8-0b87-8143-8b88-317579c22adb"],
Cell[CellGroupData[{
Cell[249384, 5261, 669, 18, 49, "Input",ExpressionUUID->"45f9b0c7-ac17-7143-ab0b-d3d0f71b41a6"],
Cell[250056, 5281, 179, 3, 33, "Output",ExpressionUUID->"598717c3-756b-4ad2-b50d-e44fbd008bb7"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[250284, 5290, 1793, 25, 37, "Subsection",ExpressionUUID->"c451b77c-53ac-674f-9c50-0e373c19a5d6"],
Cell[CellGroupData[{
Cell[252102, 5319, 671, 18, 49, "Input",ExpressionUUID->"4d12649c-c66e-4743-9b1c-b4d8d6f102c9"],
Cell[252776, 5339, 182, 3, 33, "Output",ExpressionUUID->"c923b8b2-a357-4b53-9b28-b1aa99786c08"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[253007, 5348, 1843, 26, 37, "Subsection",ExpressionUUID->"11bece52-2912-9d43-a10e-c881614b9a39"],
Cell[CellGroupData[{
Cell[254875, 5378, 669, 18, 43, "Input",ExpressionUUID->"d1903be5-5303-414a-be6e-ac11ead18e60"],
Cell[255547, 5398, 180, 3, 70, "Output",ExpressionUUID->"ecc2a27b-c65f-4652-8fe9-32a8d1101339"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[255776, 5407, 1941, 27, 37, "Subsection",ExpressionUUID->"6802181b-e72e-ea4f-b2b2-8dc1d6922c73"],
Cell[CellGroupData[{
Cell[257742, 5438, 667, 18, 49, "Input",ExpressionUUID->"02d23c76-a49b-5e45-a549-27c694978224"],
Cell[258412, 5458, 182, 3, 70, "Output",ExpressionUUID->"7dc2801c-16c1-423d-bec5-70f6959b90e3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[258643, 5467, 1939, 27, 37, "Subsection",ExpressionUUID->"1d764615-75c3-fe48-9e78-eb090dfd4057"],
Cell[CellGroupData[{
Cell[260607, 5498, 667, 18, 43, "Input",ExpressionUUID->"e4c8b1e3-f919-f84a-8d76-6e0a2fc35132"],
Cell[261277, 5518, 182, 3, 70, "Output",ExpressionUUID->"7c9799be-e4f5-42c4-9e1c-49a20697534e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[261508, 5527, 1995, 28, 37, "Subsection",ExpressionUUID->"fdd20473-86e7-8843-8d32-de024e98e3d5"],
Cell[CellGroupData[{
Cell[263528, 5559, 668, 18, 43, "Input",ExpressionUUID->"fff64508-a70d-f645-9eca-71af4670ee6b"],
Cell[264199, 5579, 180, 3, 70, "Output",ExpressionUUID->"86018ef8-8308-4316-914f-e4c13755e606"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[264428, 5588, 2041, 28, 37, "Subsection",ExpressionUUID->"33d41e51-828b-6044-a6f9-bd0aa479d079"],
Cell[CellGroupData[{
Cell[266494, 5620, 669, 18, 43, "Input",ExpressionUUID->"7786e9f9-4802-7d43-871f-cc2353fc28b5"],
Cell[267166, 5640, 180, 3, 70, "Output",ExpressionUUID->"d8e02ec3-0fb9-42c5-adb3-afbb50f7a37e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[267395, 5649, 2092, 29, 37, "Subsection",ExpressionUUID->"5d1dc4d6-cdc0-864c-bba8-602f8331245c"],
Cell[CellGroupData[{
Cell[269512, 5682, 901, 26, 60, "Input",ExpressionUUID->"84aa7a30-9f8a-124d-914f-df1b9589c9cd"],
Cell[270416, 5710, 180, 3, 70, "Output",ExpressionUUID->"08c9e370-1bfa-42f2-b5a3-5bffeec0ca10"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[270645, 5719, 2090, 29, 37, "Subsection",ExpressionUUID->"aa3866c6-4311-5948-9a9f-dd00cffc6084"],
Cell[CellGroupData[{
Cell[272760, 5752, 669, 18, 43, "Input",ExpressionUUID->"b716663b-e456-ff48-a8c9-ed9697c71e4e"],
Cell[273432, 5772, 180, 3, 70, "Output",ExpressionUUID->"cdced44a-c975-4bab-81ae-37ca5a08136c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[273661, 5781, 2142, 30, 37, "Subsection",ExpressionUUID->"4f0a0ac1-5627-e841-98ee-69ce2ecb1596"],
Cell[CellGroupData[{
Cell[275828, 5815, 669, 18, 43, "Input",ExpressionUUID->"c22cd57e-af18-904e-885f-645fdf8ac97f"],
Cell[276500, 5835, 182, 3, 70, "Output",ExpressionUUID->"a04b9570-fd10-4f6a-9a30-609ecfc33231"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[276731, 5844, 2186, 30, 37, "Subsection",ExpressionUUID->"2b9ebe7a-b725-284a-a406-a159b6cd313c"],
Cell[CellGroupData[{
Cell[278942, 5878, 669, 18, 43, "Input",ExpressionUUID->"9883f6c6-28ee-f24d-93f3-4f8a177cf1c2"],
Cell[279614, 5898, 178, 3, 70, "Output",ExpressionUUID->"33d692b4-af39-48da-8aaf-845ca3de442e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[279841, 5907, 2296, 32, 37, "Subsection",ExpressionUUID->"7d82f464-cacf-1244-b4e4-5f92b0ec2e40"],
Cell[CellGroupData[{
Cell[282162, 5943, 903, 26, 70, "Input",ExpressionUUID->"a959bcf2-3126-7044-8e67-5a6a6e1bd221"],
Cell[283068, 5971, 204, 4, 33, "Output",ExpressionUUID->"27cfa1d5-782c-4172-8f76-750bd2d774b5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[283321, 5981, 2326, 33, 37, "Subsection",ExpressionUUID->"b6afe295-63a0-3b41-99c8-12b973f6bf47"],
Cell[CellGroupData[{
Cell[285672, 6018, 905, 26, 70, "Input",ExpressionUUID->"5be977ff-2af0-254c-aa62-7489f0a14129"],
Cell[286580, 6046, 205, 4, 33, "Output",ExpressionUUID->"1d70dd39-9055-473e-9301-5ac06bffffc2"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[286834, 6056, 2260, 31, 37, "Subsection",ExpressionUUID->"1cb24f33-8dc5-2449-8448-951b6e95b0c9"],
Cell[CellGroupData[{
Cell[289119, 6091, 905, 26, 70, "Input",ExpressionUUID->"2334dd70-7bdf-4046-a95c-e8fab005d84a"],
Cell[290027, 6119, 207, 4, 33, "Output",ExpressionUUID->"1426765b-b037-420d-bd71-15472baf3c82"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[290283, 6129, 2362, 33, 37, "Subsection",ExpressionUUID->"d41c1b18-0d68-d44e-8cdd-81aad9134881"],
Cell[CellGroupData[{
Cell[292670, 6166, 901, 26, 70, "Input",ExpressionUUID->"4c6ce1bc-8489-1a4e-9a83-9b5dd1e6f967"],
Cell[293574, 6194, 205, 4, 33, "Output",ExpressionUUID->"cefbc117-6e9a-495a-9d52-168555b51e19"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[293828, 6204, 2406, 33, 37, "Subsection",ExpressionUUID->"050723f8-f06a-2d46-8937-4f741fd249c7"],
Cell[CellGroupData[{
Cell[296259, 6241, 902, 26, 70, "Input",ExpressionUUID->"849267a7-be37-f744-a433-e61b424d71d6"],
Cell[297164, 6269, 207, 4, 33, "Output",ExpressionUUID->"3d820b2a-6b04-4d1a-9d1a-b59addb531d4"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[297420, 6279, 2458, 34, 37, "Subsection",ExpressionUUID->"ffa31bcf-3487-2b43-afdf-322d9e74ae79"],
Cell[CellGroupData[{
Cell[299903, 6317, 901, 26, 70, "Input",ExpressionUUID->"87f297b1-2d0b-d147-b524-e1b623e0f7ca"],
Cell[300807, 6345, 207, 4, 33, "Output",ExpressionUUID->"a248b724-3095-419e-99e4-e02a85a111d6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[301063, 6355, 2512, 35, 37, "Subsection",ExpressionUUID->"420dad99-a90e-e04e-b4b3-bff1db226ff3"],
Cell[CellGroupData[{
Cell[303600, 6394, 669, 18, 49, "Input",ExpressionUUID->"1521c2bd-bd5c-0945-83ab-53525106548e"],
Cell[304272, 6414, 180, 3, 33, "Output",ExpressionUUID->"687bf346-3aab-4872-b79b-5f5c0879374a"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

